/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.manager;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.util.cache.JiraCachedManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

public class CachedGenericConfigManager
implements GenericConfigManager,
JiraCachedManager,
Startable {
    private static final Object NULL_VALUE = new Object();
    private final GenericConfigManager delegate;
    private final EventPublisher eventPublisher;
    private final ConcurrentMap<Key, Object> cache = new ConcurrentHashMap<Key, Object>();

    public CachedGenericConfigManager(GenericConfigManager delegate, EventPublisher eventPublisher) {
        this.delegate = delegate;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refreshCache();
    }

    @Override
    public void create(String dataType, String key, @Nullable Object obj) {
        this.delegate.create(dataType, key, obj);
        this.cache.remove(new Key(dataType, key));
    }

    @Override
    public void update(String dataType, String key, @Nullable Object obj) {
        this.delegate.update(dataType, key, obj);
        this.cache.remove(new Key(dataType, key));
    }

    @Override
    public Object retrieve(String dataType, String key) {
        Key cacheKey = new Key(dataType, key);
        Object result = this.cache.get(cacheKey);
        if (result != null) {
            if (result == NULL_VALUE) {
                return null;
            }
            return result;
        }
        Object retrieved = this.delegate.retrieve(dataType, key);
        if (retrieved == null) {
            this.cache.putIfAbsent(cacheKey, NULL_VALUE);
        } else {
            this.cache.putIfAbsent(cacheKey, retrieved);
        }
        return retrieved;
    }

    @Override
    public void remove(String dataType, String key) {
        this.delegate.remove(dataType, key);
        this.cache.remove(new Key(dataType, key));
    }

    @Override
    public long getCacheSize() {
        return this.cache.size();
    }

    @Override
    public void refreshCache() {
        this.cache.clear();
    }

    private static class Key {
        final String dataType;
        final String key;
        transient int hashCode;

        Key(String dataType, String key) {
            this.dataType = dataType;
            this.key = key;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int PRIME = 31;
                int result = 1;
                result = 31 * result + (this.dataType == null ? 0 : this.dataType.hashCode());
                this.hashCode = result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.dataType == null ? other.dataType != null : !this.dataType.equals(other.dataType)) {
                return false;
            }
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }
    }
}

