/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl.rest;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.impl.rest.AbstractCustomFieldOperationsHandler;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.rest.StandardOperation;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class UserCustomFieldOperationsHandler
extends AbstractCustomFieldOperationsHandler<String> {
    public UserCustomFieldOperationsHandler(CustomField field, I18nHelper i18nHelper) {
        super(field, i18nHelper);
    }

    @Override
    public Set<String> getSupportedOperations() {
        return ImmutableSet.of((Object)StandardOperation.SET.getName());
    }

    @Override
    protected String handleSetOperation(IssueContext issueCtx, Issue issue, String currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        return operationValue.isNull() ? null : operationValue.asObjectWithProperty("name", this.field.getId(), errors);
    }

    @Override
    protected String getInitialValue(Issue issue, ErrorCollection errors) {
        User user = (User)this.field.getValue(issue);
        return user == null ? null : user.getName();
    }

    @Override
    protected String getInitialCreateValue(IssueContext issueCtx) {
        return null;
    }

    @Override
    protected void finaliseOperation(String finalValue, IssueInputParameters parameters, ErrorCollection errors) {
        parameters.addCustomFieldValue(this.field.getId(), finalValue != null ? finalValue.toString() : "");
    }
}

