/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl.rest;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.impl.rest.AbstractCustomFieldOperationsHandler;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.rest.StandardOperation;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MultiSelectCustomFieldOperationsHandler
extends AbstractCustomFieldOperationsHandler<Collection<String>> {
    private final OptionsManager optionsManager;

    public MultiSelectCustomFieldOperationsHandler(OptionsManager optionsManager, CustomField field, I18nHelper i18nHelper) {
        super(field, i18nHelper);
        this.optionsManager = optionsManager;
    }

    @Override
    public Set<String> getSupportedOperations() {
        return ImmutableSet.of((Object)StandardOperation.ADD.getName(), (Object)StandardOperation.SET.getName(), (Object)StandardOperation.REMOVE.getName());
    }

    @Override
    protected Collection<String> handleAddOperation(IssueContext issueCtx, Issue issue, Collection<String> currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        String value;
        ArrayList<String> newList = new ArrayList<String>(currentFieldValue);
        String optionId = operationValue.asObjectWithProperty("id", this.field.getId(), errors);
        if (optionId == null && (value = operationValue.asObjectWithProperty("value", this.field.getId(), errors)) != null) {
            optionId = this.getOptionIdForValue(issueCtx, errors, value);
        }
        if (!newList.contains(optionId)) {
            newList.add(optionId);
        }
        return newList;
    }

    @Override
    protected Collection<String> handleRemoveOperation(IssueContext issueCtx, Issue issue, Collection<String> currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        String value;
        String optionId = operationValue.asObjectWithProperty("id", this.field.getId(), errors);
        if (optionId == null && (value = operationValue.asObjectWithProperty("value", this.field.getId(), errors)) != null) {
            optionId = this.getOptionIdForValue(issueCtx, errors, value);
        }
        return Collections2.filter(currentFieldValue, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)optionId)));
    }

    @Override
    protected Collection<String> handleSetOperation(IssueContext issueCtx, Issue issue, Collection<String> currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        List<String> values;
        if (operationValue.isNull()) {
            return Collections.emptyList();
        }
        HashSet<String> uniqueOptionIds = new HashSet<String>();
        List<String> optionIds = operationValue.asArrayOfObjectsWithId(this.field.getName(), errors);
        if (optionIds != null) {
            uniqueOptionIds.addAll(optionIds);
        }
        if ((values = operationValue.asArrayOfObjectsWithProperty("value", this.field.getName(), errors)) != null) {
            for (String value : values) {
                String id = this.getOptionIdForValue(issueCtx, errors, value);
                if (id != null) {
                    uniqueOptionIds.add(id);
                    continue;
                }
                errors.addError(this.field.getId(), this.i18nHelper.getText("rest.custom.field.option.value.invalid", value), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        }
        return uniqueOptionIds;
    }

    private String getOptionIdForValue(IssueContext issueCtx, ErrorCollection errors, String value) {
        String optionId = null;
        FieldConfig config = this.field.getRelevantConfig(issueCtx);
        Options options = this.optionsManager.getOptions(config);
        for (Option option : options) {
            if (!option.getValue().equals(value)) continue;
            optionId = option.getOptionId().toString();
            break;
        }
        if (optionId == null) {
            errors.addError(this.field.getId(), this.i18nHelper.getText("rest.custom.field.option.value.invalid", value), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        return optionId;
    }

    @Override
    protected List<String> getInitialCreateValue(IssueContext issueCtx) {
        return Collections.emptyList();
    }

    @Override
    protected List<String> getInitialValue(Issue issue, ErrorCollection errors) {
        Collection fieldValue = (Collection)this.field.getValue(issue);
        if (fieldValue == null) {
            return Collections.emptyList();
        }
        Iterable options = Iterables.transform((Iterable)fieldValue, (Function)new Function<Option, String>(){

            public String apply(Option from) {
                return from.getOptionId().toString();
            }
        });
        return Lists.newArrayList((Iterable)options);
    }

    @Override
    protected void finaliseOperation(Collection<String> finalValue, IssueInputParameters parameters, ErrorCollection errors) {
        parameters.addCustomFieldValue(this.field.getId(), finalValue.toArray(new String[finalValue.size()]));
    }
}

