/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.imports.project.customfield.VersionCustomFieldImporter;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.issue.comparator.VersionComparator;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.RequiresProjectSelectedMarker;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.config.item.VersionOptionsConfigItem;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractMultiCFType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.impl.rest.MultiVersionCustomFieldOperationsHandler;
import com.atlassian.jira.issue.customfields.impl.rest.SingleVersionCustomFieldOperationsHandler;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItemType;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.renderer.HackyRendererType;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareCustomFieldType;
import com.atlassian.jira.issue.fields.rest.RestCustomFieldTypeOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.VersionJsonBean;
import com.atlassian.jira.issue.fields.util.VersionHelperBean;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.web.bean.BulkEditBean;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class VersionCFType
extends AbstractMultiCFType<Version>
implements RequiresProjectSelectedMarker,
SortableCustomField,
ProjectImportableCustomField,
RestAwareCustomFieldType,
RestCustomFieldTypeOperations {
    private final Logger log = Logger.getLogger(VersionCFType.class);
    private static final String NO_VERSION_STRING = "-1";
    private static final PersistenceFieldType DB_TYPE = PersistenceFieldType.TYPE_DECIMAL;
    private static final String MULTIPLE_PARAM_KEY = "multiple";
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;
    private final VersionManager versionManager;
    private final VersionHelperBean versionHelperBean;
    private final VersionCustomFieldImporter versionCustomFieldImporter;
    private final JiraBaseUrls jiraBaseUrls;

    public VersionCFType(PermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext, VersionManager versionManager, CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager, VersionHelperBean versionHelperBean, JiraBaseUrls jiraBaseUrls) {
        super(customFieldValuePersister, genericConfigManager);
        this.permissionManager = permissionManager;
        this.authenticationContext = jiraAuthenticationContext;
        this.versionManager = versionManager;
        this.versionHelperBean = versionHelperBean;
        this.jiraBaseUrls = jiraBaseUrls;
        this.versionCustomFieldImporter = new VersionCustomFieldImporter();
    }

    @Override
    public void validateFromParams(CustomFieldParams relevantParams, ErrorCollection errorCollectionToAddTo, FieldConfig config) {
        Collection versionIds = relevantParams.getAllValues();
        if (versionIds != null && versionIds.isEmpty()) {
            CustomField customField = config.getCustomField();
            this.versionHelperBean.validateVersionIds(versionIds, errorCollectionToAddTo, this.getI18nBean(), customField.getId());
        }
    }

    @Override
    public Collection<Version> getValueFromCustomFieldParams(CustomFieldParams parameters) throws FieldValidationException {
        Collection allValues = parameters.getAllValues();
        Collection collection = CollectionUtils.collect((Collection)allValues, (Transformer)new Transformer(){

            public Object transform(Object input) {
                String versionIdString = (String)input;
                Long versionId = VersionCFType.this.getLongFromString(versionIdString);
                return VersionCFType.this.versionManager.getVersion(versionId);
            }
        });
        if (CustomFieldUtils.isCollectionNotEmpty(collection)) {
            return collection;
        }
        return null;
    }

    @Override
    public Object getStringValueFromCustomFieldParams(CustomFieldParams parameters) {
        return parameters.getAllValues();
    }

    @Override
    public String getChangelogString(CustomField field, Collection<Version> versions) {
        if (versions != null) {
            StringBuilder sb = new StringBuilder();
            Iterator<Version> iterator = versions.iterator();
            while (iterator.hasNext()) {
                Version version = iterator.next();
                if (version == null) continue;
                sb.append(version.getName());
                if (!iterator.hasNext()) continue;
                sb.append(", ");
            }
            return sb.toString();
        }
        return null;
    }

    @Override
    public String getStringFromSingularObject(Version version) {
        if (version == null) {
            return NO_VERSION_STRING;
        }
        return String.valueOf(version.getId());
    }

    @Override
    public Version getSingularObjectFromString(String string) throws FieldValidationException {
        if (StringUtils.isEmpty((String)string) || NO_VERSION_STRING.equals(string)) {
            return null;
        }
        Long versionId = this.getLongFromString(string);
        return this.versionManager.getVersion(versionId);
    }

    public int compare(@NotNull Object customFieldObjectValue1, @NotNull Object customFieldObjectValue2, FieldConfig fieldConfig) {
        if (customFieldObjectValue1 instanceof GenericValue && customFieldObjectValue2 instanceof GenericValue) {
            this.log.debug((Object)"Comparing generic values instead of versions!");
            return OfBizComparators.NAME_COMPARATOR.compare((GenericValue)customFieldObjectValue1, (GenericValue)customFieldObjectValue2);
        }
        if (customFieldObjectValue1 instanceof Version && customFieldObjectValue2 instanceof Version) {
            return new VersionComparator().compare((Version)customFieldObjectValue1, (Version)customFieldObjectValue2);
        }
        throw new IllegalArgumentException("The objects are not of the expected type.");
    }

    @Override
    @NotNull
    public List<FieldConfigItemType> getConfigurationItemTypes() {
        List<FieldConfigItemType> configurationItemTypes = super.getConfigurationItemTypes();
        configurationItemTypes.add(new VersionOptionsConfigItem(this.versionManager));
        return configurationItemTypes;
    }

    @Override
    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        if (!bulkEditBean.isMultipleProjects() && bulkEditBean.getProject() != null) {
            if (this.versionManager.getVersions(bulkEditBean.getProject()).isEmpty()) {
                return "bulk.edit.unavailable.noversions";
            }
            return null;
        }
        return "bulk.edit.unavailable.multipleprojects";
    }

    @Override
    @NotNull
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        Map<String, Object> velocityParameters = super.getVelocityParameters(issue, field, fieldLayoutItem);
        if (issue != null) {
            Collection<Version> releasedversion = this.versionManager.getVersionsReleasedDesc(issue.getProjectObject().getId(), false);
            Collection<Version> unreleasedversion = this.versionManager.getVersionsUnreleased(issue.getProjectObject().getId(), false);
            Collection currentlySelectedArchivedVersions = this.getCurrentlySelectedArchivedVersions(issue, field);
            velocityParameters.put("unknownVersionId", -1L);
            velocityParameters.put("releasedVersion", releasedversion);
            velocityParameters.put("unreleasedVersion", unreleasedversion);
            velocityParameters.put("archivedVersions", currentlySelectedArchivedVersions);
            if (fieldLayoutItem != null) {
                velocityParameters.put("isFrotherControl", HackyRendererType.fromKey(fieldLayoutItem.getRendererType()) == HackyRendererType.FROTHER_CONTROL);
            }
        }
        velocityParameters.put("collection", new CollectionUtils());
        velocityParameters.put(MULTIPLE_PARAM_KEY, Boolean.valueOf((String)this.getDescriptor().getParams().get(MULTIPLE_PARAM_KEY)));
        return velocityParameters;
    }

    @Override
    public ProjectCustomFieldImporter getProjectImporter() {
        return this.versionCustomFieldImporter;
    }

    public boolean isMultiple() {
        return Boolean.valueOf((String)this.getDescriptor().getParams().get(MULTIPLE_PARAM_KEY));
    }

    private Collection getCurrentlySelectedArchivedVersions(Issue issue, CustomField field) {
        Object selectedVersions = this.getValueFromIssue(field, issue);
        if (selectedVersions != null && !selectedVersions.isEmpty()) {
            return CollectionUtils.select((Collection)selectedVersions, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    Version version = (Version)object;
                    return version.isArchived();
                }
            });
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    protected Comparator<Version> getTypeComparator() {
        return new VersionComparator();
    }

    @Override
    protected Object convertTypeToDbValue(Version value) {
        if (value != null) {
            return new Double(value.getId().longValue());
        }
        return null;
    }

    @Override
    protected Version convertDbValueToType(Object input) {
        if (input != null) {
            Double versionIdDouble = (Double)input;
            Long versionId = new Long(versionIdDouble.longValue());
            return this.versionManager.getVersion(versionId);
        }
        return null;
    }

    @Override
    @NotNull
    protected PersistenceFieldType getDatabaseType() {
        return DB_TYPE;
    }

    private Long getLongFromString(String stringValue) throws FieldValidationException {
        try {
            return Long.valueOf(stringValue);
        }
        catch (NumberFormatException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            throw new FieldValidationException("Version Id is not a number '" + stringValue + "'");
        }
    }

    @Override
    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitVersion(this);
        }
        return super.accept(visitor);
    }

    @Override
    public RestFieldOperationsHandler getRestFieldOperation(CustomField field) {
        if (this.isMultiple()) {
            return new MultiVersionCustomFieldOperationsHandler(field, this.versionManager, this.authenticationContext.getI18nHelper());
        }
        return new SingleVersionCustomFieldOperationsHandler(field, this.versionManager, this.authenticationContext.getI18nHelper());
    }

    @Override
    public JsonData getJsonDefaultValue(IssueContext issueCtx, CustomField field) {
        List<Version> projects = this.versionManager.getVersions(issueCtx.getProjectObject());
        return new JsonData(VersionJsonBean.shortBeans(projects, this.jiraBaseUrls));
    }

    @Override
    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        List<Version> projects = this.versionManager.getVersions(fieldTypeInfoContext.getIssueContext().getProjectObject());
        return new FieldTypeInfo(Collections.singletonList(VersionJsonBean.shortBeans(projects, this.jiraBaseUrls)), null);
    }

    @Override
    public JsonType getJsonSchema(CustomField customField) {
        if (this.isMultiple()) {
            return JsonTypeBuilder.customArray("version", this.getKey(), customField.getIdAsLong());
        }
        return JsonTypeBuilder.custom("version", this.getKey(), customField.getIdAsLong());
    }

    @Override
    public FieldJsonRepresentation getJsonFromIssue(CustomField field, Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        Object versions = this.getValueFromIssue(field, issue);
        if (versions == null) {
            return new FieldJsonRepresentation(new JsonData(null));
        }
        if (this.isMultiple()) {
            return new FieldJsonRepresentation(new JsonData(VersionJsonBean.shortBeans((Collection<Version>)versions, this.jiraBaseUrls)));
        }
        if (versions.isEmpty()) {
            return new FieldJsonRepresentation(new JsonData(null));
        }
        return new FieldJsonRepresentation(new JsonData(VersionJsonBean.shortBean((Version)versions.iterator().next(), this.jiraBaseUrls)));
    }

    public static interface Visitor<X>
    extends AbstractCustomFieldType.VisitorBase<X> {
        public X visitVersion(VersionCFType var1);
    }
}

