/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.imports.project.customfield.ProjectPickerCustomFieldImporter;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.config.item.ProjectOptionsConfigItem;
import com.atlassian.jira.issue.customfields.converters.ProjectConverter;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractSingleFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.impl.rest.ProjectCustomFieldOperationsHandler;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItemType;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareCustomFieldType;
import com.atlassian.jira.issue.fields.rest.RestCustomFieldTypeOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.ProjectJsonBean;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.NotNull;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class ProjectCFType
extends AbstractSingleFieldType<GenericValue>
implements SortableCustomField<GenericValue>,
ProjectImportableCustomField,
RestAwareCustomFieldType,
RestCustomFieldTypeOperations {
    private final Logger log = Logger.getLogger(ProjectCFType.class);
    private final ProjectConverter projectConverter;
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ProjectCustomFieldImporter projectCustomFieldImporter;
    private final JiraBaseUrls jiraBaseUrls;

    public ProjectCFType(CustomFieldValuePersister customFieldValuePersister, ProjectConverter projectConverter, PermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext, GenericConfigManager genericConfigManager, JiraBaseUrls jiraBaseUrls, ProjectManager projectManager) {
        super(customFieldValuePersister, genericConfigManager);
        this.projectConverter = projectConverter;
        this.permissionManager = permissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.jiraBaseUrls = jiraBaseUrls;
        this.projectManager = projectManager;
        this.projectCustomFieldImporter = new ProjectPickerCustomFieldImporter();
    }

    @Override
    public int compare(@NotNull GenericValue customFieldObjectValue1, @NotNull GenericValue customFieldObjectValue2, FieldConfig fieldConfig) {
        return OfBizComparators.NAME_COMPARATOR.compare(customFieldObjectValue1, customFieldObjectValue2);
    }

    @Override
    @NotNull
    protected PersistenceFieldType getDatabaseType() {
        return PersistenceFieldType.TYPE_DECIMAL;
    }

    @Override
    protected Object getDbValueFromObject(GenericValue customFieldObject) {
        if (customFieldObject == null) {
            return null;
        }
        return new Double(customFieldObject.getLong("id").longValue());
    }

    @Override
    protected GenericValue getObjectFromDbValue(@NotNull Object databaseValue) throws FieldValidationException {
        Double projectId = (Double)databaseValue;
        return this.projectConverter.getProject(new Long(projectId.intValue()));
    }

    @Override
    public String getStringFromSingularObject(GenericValue customFieldObject) {
        return this.projectConverter.getString(customFieldObject);
    }

    @Override
    public GenericValue getSingularObjectFromString(String string) throws FieldValidationException {
        return this.projectConverter.getProject(string);
    }

    @Override
    @NotNull
    public List<FieldConfigItemType> getConfigurationItemTypes() {
        List<FieldConfigItemType> configurationItemTypes = super.getConfigurationItemTypes();
        configurationItemTypes.add(new ProjectOptionsConfigItem(this.projectConverter, this.permissionManager, this.jiraAuthenticationContext));
        return configurationItemTypes;
    }

    @Override
    public String getChangelogString(CustomField field, GenericValue value) {
        if (value == null) {
            return null;
        }
        return value.getString("name");
    }

    @Override
    @NotNull
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        GenericValue project;
        Map<String, Object> params = super.getVelocityParameters(issue, field, fieldLayoutItem);
        if (issue != null && (project = (GenericValue)this.getValueFromIssue(field, issue)) != null) {
            boolean hasPermission = this.permissionManager.hasPermission(10, project, this.jiraAuthenticationContext.getLoggedInUser());
            params.put("isProjectVisible", hasPermission ? Boolean.TRUE : Boolean.FALSE);
        }
        return params;
    }

    @Override
    public ProjectCustomFieldImporter getProjectImporter() {
        return this.projectCustomFieldImporter;
    }

    @Override
    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitProject(this);
        }
        return super.accept(visitor);
    }

    @Override
    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        Collection<Project> projects = this.permissionManager.getProjectObjects(10, this.jiraAuthenticationContext.getLoggedInUser());
        return new FieldTypeInfo(Collections.singletonList(ProjectJsonBean.shortBeans(projects, this.jiraBaseUrls)), null);
    }

    @Override
    public JsonType getJsonSchema(CustomField customField) {
        return JsonTypeBuilder.custom("project", this.getKey(), customField.getIdAsLong());
    }

    @Override
    public FieldJsonRepresentation getJsonFromIssue(CustomField field, Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        GenericValue valueFromIssue = (GenericValue)this.getValueFromIssue(field, issue);
        if (valueFromIssue == null) {
            return new FieldJsonRepresentation(new JsonData(null));
        }
        Project project = this.projectConverter.getProjectObject(valueFromIssue.getLong("id"));
        return new FieldJsonRepresentation(new JsonData(ProjectJsonBean.shortBean(project, this.jiraBaseUrls)));
    }

    @Override
    public RestFieldOperationsHandler getRestFieldOperation(CustomField field) {
        return new ProjectCustomFieldOperationsHandler(this.projectManager, field, this.getI18nBean());
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitProject(ProjectCFType var1);
    }
}

