/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.jira.imports.project.customfield.NoTransformationCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractSingleFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.impl.rest.NumberCustomFieldOperationsHandler;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareCustomFieldType;
import com.atlassian.jira.issue.fields.rest.RestCustomFieldTypeOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.velocity.NumberTool;
import java.util.Map;
import javax.annotation.Nullable;

public class NumberCFType
extends AbstractSingleFieldType<Double>
implements SortableCustomField<Double>,
ProjectImportableCustomField,
RestAwareCustomFieldType,
RestCustomFieldTypeOperations {
    private final DoubleConverter doubleConverter;
    private final ProjectCustomFieldImporter projectCustomFieldImporter;

    public NumberCFType(CustomFieldValuePersister customFieldValuePersister, DoubleConverter doubleConverter, GenericConfigManager genericConfigManager) {
        super(customFieldValuePersister, genericConfigManager);
        this.doubleConverter = doubleConverter;
        this.projectCustomFieldImporter = new NoTransformationCustomFieldImporter();
    }

    @Override
    @NotNull
    protected PersistenceFieldType getDatabaseType() {
        return PersistenceFieldType.TYPE_DECIMAL;
    }

    @Override
    public String getStringFromSingularObject(Double customFieldObject) {
        return this.doubleConverter.getString(customFieldObject);
    }

    @Override
    public Double getSingularObjectFromString(String string) throws FieldValidationException {
        return this.doubleConverter.getDouble(string);
    }

    @Override
    public String getChangelogValue(CustomField field, Double value) {
        if (value == null) {
            return "";
        }
        return this.doubleConverter.getStringForChangelog(value);
    }

    @Override
    public int compare(@NotNull Double customFieldObjectValue1, @NotNull Double customFieldObjectValue2, FieldConfig fieldConfig) {
        return customFieldObjectValue1.compareTo(customFieldObjectValue2);
    }

    @Override
    protected Object getDbValueFromObject(Double customFieldObject) {
        return customFieldObject;
    }

    @Override
    protected Double getObjectFromDbValue(@NotNull Object databaseValue) throws FieldValidationException {
        return (Double)databaseValue;
    }

    @Override
    @NotNull
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        Map<String, Object> map = super.getVelocityParameters(issue, field, fieldLayoutItem);
        map.put("numberTool", new NumberTool(this.getI18nBean().getLocale()));
        return map;
    }

    @Override
    public ProjectCustomFieldImporter getProjectImporter() {
        return this.projectCustomFieldImporter;
    }

    @Override
    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitNumber(this);
        }
        return super.accept(visitor);
    }

    @Override
    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return new FieldTypeInfo(null, null);
    }

    @Override
    public JsonType getJsonSchema(CustomField customField) {
        return JsonTypeBuilder.custom("number", this.getKey(), customField.getIdAsLong());
    }

    @Override
    public FieldJsonRepresentation getJsonFromIssue(CustomField field, Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        Double number = (Double)this.getValueFromIssue(field, issue);
        return new FieldJsonRepresentation(new JsonData(number));
    }

    @Override
    public RestFieldOperationsHandler getRestFieldOperation(CustomField field) {
        return new NumberCustomFieldOperationsHandler(field, this.doubleConverter, this.getI18nBean());
    }

    public static interface Visitor<X>
    extends AbstractCustomFieldType.VisitorBase<X> {
        public X visitNumber(NumberCFType var1);
    }
}

