/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.converters;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.customfields.converters.UserConverter;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.user.util.UserUtil;
import org.apache.commons.lang.StringUtils;

public class UserConverterImpl
implements UserConverter {
    private final UserUtil userUtil;

    public UserConverterImpl(UserUtil userUtil) {
        this.userUtil = userUtil;
    }

    @Override
    public String getString(User user) {
        if (user == null) {
            return "";
        }
        return user.getName();
    }

    @Override
    public User getUser(String stringValue) throws FieldValidationException {
        if (StringUtils.isBlank((String)stringValue)) {
            return null;
        }
        User user = this.userUtil.getUser(stringValue);
        if (user == null) {
            throw new FieldValidationException("User '" + stringValue + "' was not found in the system.");
        }
        return user;
    }

    @Override
    public User getUserObject(String stringValue) throws FieldValidationException {
        return this.getUser(stringValue);
    }
}

