/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.converters;

import com.atlassian.jira.issue.customfields.converters.SelectConverter;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchContextImpl;
import com.atlassian.jira.util.ofbiz.GenericValueUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.GenericValue;

public class SelectConverterImpl
implements SelectConverter {
    private final OptionsManager optionsManager;

    public SelectConverterImpl(OptionsManager optionsManager) {
        this.optionsManager = optionsManager;
    }

    @Override
    public String getString(Object value) {
        if (value == null) {
            return "-1";
        }
        if (!(value instanceof String)) {
            return null;
        }
        return (String)value;
    }

    @Override
    public String getObject(String stringValue) {
        if ("".equals(stringValue) || "-1".equals(stringValue) || "-2".equals(stringValue)) {
            return null;
        }
        return stringValue;
    }

    @Override
    public SearchContext getPossibleSearchContextFromValue(Object value, CustomField customField) {
        String stringValue = this.getString(value);
        HashSet<Long> projectIds = new HashSet<Long>();
        HashSet<String> issueTypeIds = new HashSet<String>();
        for (FieldConfigScheme configScheme : customField.getConfigurationSchemes()) {
            Set entries = configScheme.getConfigsByConfig().entrySet();
            for (Map.Entry entry : entries) {
                Set<GenericValue> associatedIssueTypes;
                FieldConfig config = (FieldConfig)entry.getKey();
                Options options = this.optionsManager.getOptions(config);
                if (options.getOptionForValue(stringValue, null) == null) continue;
                if (configScheme.isGlobal()) {
                    return new SearchContextImpl();
                }
                List<GenericValue> associatedProjects = configScheme.getAssociatedProjects();
                if (associatedProjects != null) {
                    projectIds.addAll(GenericValueUtils.transformToLongIdsList(associatedProjects));
                }
                if ((associatedIssueTypes = configScheme.getAssociatedIssueTypes()) == null) continue;
                issueTypeIds.addAll(GenericValueUtils.transformToStringIdsList(associatedIssueTypes));
            }
        }
        projectIds.remove(ALL_LONG);
        issueTypeIds.remove("-1");
        return new SearchContextImpl(null, new ArrayList(projectIds), new ArrayList(issueTypeIds));
    }
}

