/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.context.persistence;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.ProjectContext;
import com.atlassian.jira.issue.context.manager.JiraContextTreeManager;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersister;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class FieldConfigContextPersisterImpl
implements FieldConfigContextPersister {
    public static final String ENTITY_TABLE_NAME = "ConfigurationContext";
    public static final String ENTITY_PROJECT_CATEGORY = "projectcategory";
    public static final String ENTITY_PROJECT = "project";
    public static final String ENTITY_KEY = "key";
    public static final String ENTITY_CONFIG = "fieldconfigscheme";
    private final OfBizDelegator delegator;
    private final ProjectManager projectManager;
    private final JiraContextTreeManager treeManager;
    private static final Logger log = Logger.getLogger(FieldConfigContextPersisterImpl.class);

    public FieldConfigContextPersisterImpl(OfBizDelegator delegator, ProjectManager projectManager, JiraContextTreeManager treeManager) {
        this.delegator = delegator;
        this.projectManager = projectManager;
        this.treeManager = treeManager;
    }

    @Override
    public List<JiraContextNode> getAllContextsForCustomField(String key) {
        return CollectionUtil.transform(this.delegator.findByAnd(ENTITY_TABLE_NAME, MapBuilder.build(ENTITY_KEY, key)), new Function<GenericValue, JiraContextNode>(){

            @Override
            public JiraContextNode get(GenericValue input) {
                return FieldConfigContextPersisterImpl.this.transformToDomainObject(input);
            }
        });
    }

    @Override
    public List<JiraContextNode> getAllContextsForConfigScheme(FieldConfigScheme fieldConfigScheme) {
        return CollectionUtil.transform(this.delegator.findByAnd(ENTITY_TABLE_NAME, MapBuilder.build(ENTITY_CONFIG, fieldConfigScheme.getId())), new Function<GenericValue, JiraContextNode>(){

            @Override
            public JiraContextNode get(GenericValue input) {
                return FieldConfigContextPersisterImpl.this.transformToDomainObject(input);
            }
        });
    }

    @Override
    public void removeContextsForConfigScheme(Long fieldConfigSchemeId) {
        int result = this.delegator.removeByAnd(ENTITY_TABLE_NAME, MapBuilder.build(ENTITY_CONFIG, fieldConfigSchemeId));
        if (log.isDebugEnabled()) {
            log.debug((Object)(result + " contexts deleted for field config scheme with id '" + fieldConfigSchemeId + "'"));
        }
    }

    @Override
    public void removeContextsForProject(GenericValue project) {
        int result = this.delegator.removeByAnd(ENTITY_TABLE_NAME, MapBuilder.build(ENTITY_PROJECT, project.getLong("id")));
        if (log.isDebugEnabled()) {
            log.debug((Object)(result + " contexts deleted for " + project));
        }
    }

    @Override
    public void removeContextsForProjectCategory(ProjectCategory projectCategory) {
        int result = this.delegator.removeByAnd(ENTITY_TABLE_NAME, MapBuilder.build(ENTITY_PROJECT_CATEGORY, projectCategory.getId()));
        if (log.isDebugEnabled()) {
            log.debug((Object)(result + " contexts deleted for " + projectCategory));
        }
    }

    public Object retrieve(BandanaContext context, String key) {
        List<GenericValue> result;
        if (context != null && (result = this.delegator.findByAnd(ENTITY_TABLE_NAME, this.transformToFieldsMap((JiraContextNode)context).add(ENTITY_KEY, key).toMap())) != null && !result.isEmpty()) {
            Long schemeId = result.iterator().next().getLong(ENTITY_CONFIG);
            if (result.size() > 1) {
                log.warn((Object)("More than one FieldConfigScheme returned for a given context. Database may be corrupted.Returning first Long: " + schemeId + ". Context: " + context + " with key: " + key + " returned " + result + "."));
            }
            return schemeId;
        }
        return null;
    }

    public void store(BandanaContext context, String key, Object value) {
        JiraContextNode contextNode = (JiraContextNode)context;
        FieldConfigScheme config = (FieldConfigScheme)value;
        if (this.retrieve(contextNode, key) != null) {
            this.remove(contextNode, key);
        }
        if (config != null) {
            MapBuilder<String, Object> props = this.transformToFieldsMap(contextNode);
            props.add(ENTITY_KEY, key);
            props.add(ENTITY_CONFIG, config.getId());
            try {
                EntityUtils.createValue(ENTITY_TABLE_NAME, props.toMap());
            }
            catch (GenericEntityException e) {
                throw new DataAccessException(e);
            }
        }
    }

    public void flushCaches() {
        throw new IllegalArgumentException();
    }

    public void remove(BandanaContext context) {
        if (context != null) {
            JiraContextNode contextNode = (JiraContextNode)context;
            this.delegator.removeByAnd(ENTITY_TABLE_NAME, this.transformToFieldsMap(contextNode).toMap());
        } else {
            log.warn((Object)"Context was null. Nothing was removed");
        }
    }

    public void remove(BandanaContext context, String key) {
        if (context != null && key != null) {
            this.delegator.removeByAnd(ENTITY_TABLE_NAME, this.transformToFieldsMap((JiraContextNode)context).add(ENTITY_KEY, key).toMap());
        } else {
            log.warn((Object)"Context or key was null. Nothing was removed");
        }
    }

    private MapBuilder<String, Object> transformToFieldsMap(JiraContextNode contextNode) {
        return MapBuilder.newBuilder(contextNode.appendToParamsMap(Collections.<String, Object>emptyMap()));
    }

    private JiraContextNode transformToDomainObject(GenericValue gv) {
        return new ProjectContext(this.projectManager.getProject(gv.getLong(ENTITY_PROJECT)), this.treeManager);
    }
}

