/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.context;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import org.ofbiz.core.entity.GenericValue;

public class LazyIssueContext
implements IssueContext {
    private Long projectId;
    private String issueTypeId;
    private final ConstantsManager constantsManager = ManagerFactory.getConstantsManager();
    private final ProjectManager projectManager = ManagerFactory.getProjectManager();

    public LazyIssueContext(Long projectId, String issueTypeId) {
        this.projectId = projectId;
        this.issueTypeId = issueTypeId;
    }

    @Override
    public Project getProjectObject() {
        return this.projectManager.getProjectObj(this.projectId);
    }

    @Override
    public GenericValue getProject() {
        return this.projectManager.getProject(this.projectId);
    }

    @Override
    public IssueType getIssueTypeObject() {
        return this.constantsManager.getIssueTypeObject(this.issueTypeId);
    }

    @Override
    public GenericValue getIssueType() {
        return this.constantsManager.getIssueType(this.issueTypeId);
    }
}

