/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comparator;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.comparator.NullComparator;
import com.atlassian.jira.issue.comparator.ProjectComparator;
import com.atlassian.jira.issue.comparator.util.DelegatingComparator;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public abstract class SequencedGVsComparator
implements Comparator {
    public static final Comparator FIX_FOR_VERSION_COMPARATOR = new DelegatingComparator(new ProjectComparator(), new FixForVersionIssueGVsComparator());
    public static final Comparator RAISED_IN_COMPARATOR = new DelegatingComparator(new ProjectComparator(), new RaisedInVersionIssueGVsComparator());
    public static final Comparator COMPONENT_COMPARATOR = new DelegatingComparator(new ProjectComparator(), new ComponentIssueGVsComparator());
    private static final Comparator NULL_COMPARATOR = new NullComparator();

    public int compare(Object o1, Object o2) {
        if (!(o1 instanceof GenericValue) || !(o2 instanceof GenericValue)) {
            throw new IllegalArgumentException("SequencedGVsComparator can only be used to compare two issues.  Instead got " + o1 + " " + o2);
        }
        GenericValue issue1 = (GenericValue)o1;
        GenericValue issue2 = (GenericValue)o2;
        List<GenericValue> GVs1 = null;
        List<GenericValue> GVs2 = null;
        try {
            GVs1 = this.getIssueManager().getEntitiesByIssue(this.getIssueRelationConstant(), issue1);
            GVs2 = this.getIssueManager().getEntitiesByIssue(this.getIssueRelationConstant(), issue2);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
        Comparable earliestSequence1 = this.getEarliestInCollection(GVs1);
        Comparable earliestSequence2 = this.getEarliestInCollection(GVs2);
        return NULL_COMPARATOR.compare(earliestSequence1, earliestSequence2);
    }

    private IssueManager getIssueManager() {
        return ComponentAccessor.getIssueManager();
    }

    private Comparable getEarliestInCollection(Collection versions1) {
        Comparable earliestObject = null;
        for (GenericValue gv : versions1) {
            Comparable current = this.getComparableField(gv);
            if (earliestObject != null && current.compareTo(earliestObject) >= 1) continue;
            earliestObject = current;
        }
        return earliestObject;
    }

    protected abstract Comparable getComparableField(GenericValue var1);

    protected abstract String getIssueRelationConstant();

    public static class ComponentIssueGVsComparator
    extends SequencedGVsComparator {
        @Override
        protected Comparable getComparableField(GenericValue gv) {
            return gv.getString("name");
        }

        @Override
        protected String getIssueRelationConstant() {
            return "IssueComponent";
        }
    }

    public static class RaisedInVersionIssueGVsComparator
    extends SequencedGVsComparator {
        @Override
        protected Comparable getComparableField(GenericValue gv) {
            return gv.getLong("sequence");
        }

        @Override
        protected String getIssueRelationConstant() {
            return "IssueVersion";
        }
    }

    public static class FixForVersionIssueGVsComparator
    extends SequencedGVsComparator {
        @Override
        protected Comparable getComparableField(GenericValue gv) {
            return gv.getLong("sequence");
        }

        @Override
        protected String getIssueRelationConstant() {
            return "IssueFixVersion";
        }
    }
}

