/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comparator;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import java.util.Comparator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class SecurityComparator
implements Comparator {
    public int compare(Object o1, Object o2) {
        GenericValue i1 = (GenericValue)o1;
        GenericValue i2 = (GenericValue)o2;
        if (i1 == null && i2 == null) {
            return 0;
        }
        if (i2 == null) {
            return -1;
        }
        if (i1 == null) {
            return 1;
        }
        Long securityId1 = i1.getLong("security");
        Long securityId2 = i2.getLong("security");
        if (securityId1 == null && securityId2 == null) {
            return 0;
        }
        if (securityId1 == null) {
            return 1;
        }
        if (securityId2 == null) {
            return -1;
        }
        IssueSecurityLevelManager issueSecurityLevelManager = ManagerFactory.getIssueSecurityLevelManager();
        try {
            GenericValue issueSecurityLevel1 = issueSecurityLevelManager.getIssueSecurityLevel(securityId1);
            GenericValue issueSecurityLevel2 = issueSecurityLevelManager.getIssueSecurityLevel(securityId2);
            return issueSecurityLevel1.getString("name").compareTo(issueSecurityLevel2.getString("name"));
        }
        catch (GenericEntityException e) {
            return 0;
        }
    }
}

