/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comparator;

import com.atlassian.jira.config.ConstantsManager;
import java.util.Comparator;
import org.ofbiz.core.entity.GenericValue;

public class IssueTypeKeyComparator
implements Comparator {
    private final ConstantsManager constantsManager;

    public IssueTypeKeyComparator(ConstantsManager constantsManager) {
        this.constantsManager = constantsManager;
    }

    public int compare(Object o1, Object o2) {
        if ((o1 instanceof String || o1 == null) && (o2 instanceof String || o2 == null)) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            GenericValue issueTypeGV1 = this.constantsManager.getIssueType((String)o1);
            GenericValue issueTypeGV2 = this.constantsManager.getIssueType((String)o2);
            Long sequence1 = issueTypeGV1.getLong("sequence");
            Long sequence2 = issueTypeGV2.getLong("sequence");
            if (sequence1 == null) {
                if (sequence2 == null) {
                    return 0;
                }
                return -1;
            }
            if (sequence2 == null) {
                return 1;
            }
            return sequence1.compareTo(sequence2);
        }
        throw new IllegalArgumentException("Can only compare ids of issue types.");
    }
}

