/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comments.util;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.comments.util.CommentIterator;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;

public abstract class DatabaseCommentIterator
implements CommentIterator {
    private final OfBizDelegator delegator;
    private final CommentManager commentManager;
    private final Collection<Long> issueIds;
    private final User user;
    private OfBizListIterator commentsIterator;
    private Comment nextComment;

    public DatabaseCommentIterator(OfBizDelegator delegator, CommentManager commentManager, Collection<Long> issueIds, User user) {
        this.delegator = delegator;
        this.commentManager = commentManager;
        this.issueIds = issueIds;
        this.user = user;
    }

    @Override
    public boolean hasNext() {
        this.populateNextCommentIfNull();
        return this.nextComment != null;
    }

    @Override
    public Comment next() {
        return this.nextComment();
    }

    private void populateNextCommentIfNull() {
        if (this.nextComment == null) {
            this.pullNextComment();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove an issue from an Comment Iterator");
    }

    @Override
    public Comment nextComment() {
        this.populateNextCommentIfNull();
        if (this.nextComment == null) {
            throw new NoSuchElementException();
        }
        Comment comment = this.nextComment;
        this.nextComment = null;
        return comment;
    }

    @Override
    public void close() {
        if (this.commentsIterator != null) {
            this.commentsIterator.close();
        }
    }

    @Override
    public int size() {
        EntityExpr commentExpr = new EntityExpr("type", EntityOperator.EQUALS, (Object)"comment");
        EntityExpr issueIdsClause = new EntityExpr("issue", EntityOperator.IN, this.issueIds);
        EntityExpr condition = new EntityExpr((EntityCondition)commentExpr, EntityOperator.AND, (EntityCondition)issueIdsClause);
        List<GenericValue> commentCount = this.delegator.findByCondition("ActionCount", (EntityCondition)condition, EasyList.build((Object)"count"), Collections.EMPTY_LIST);
        if (commentCount != null && commentCount.size() == 1) {
            GenericValue commentCountGV = commentCount.get(0);
            return (int)commentCountGV.getLong("count").longValue();
        }
        throw new DataAccessException("Unable to access the count for the Action table");
    }

    public OfBizListIterator getCommentsIterator() {
        if (this.commentsIterator == null) {
            EntityExpr commentExpr = new EntityExpr("type", EntityOperator.EQUALS, (Object)"comment");
            EntityExpr issueIdsClause = new EntityExpr("issue", EntityOperator.IN, this.issueIds);
            EntityExpr condition = new EntityExpr((EntityCondition)commentExpr, EntityOperator.AND, (EntityCondition)issueIdsClause);
            this.commentsIterator = this.delegator.findListIteratorByCondition("Action", (EntityCondition)condition, null, null, EasyList.build((Object)"created DESC"), null);
        }
        return this.commentsIterator;
    }

    private void pullNextComment() {
        do {
            GenericValue commentGV;
            if ((commentGV = this.getCommentsIterator().next()) == null) {
                return;
            }
            this.nextComment = this.commentManager.convertToComment(commentGV);
        } while (!this.hasReadPermissionForAction(this.nextComment, this.nextComment.getIssue(), this.user));
    }

    protected abstract boolean hasReadPermissionForAction(Comment var1, Issue var2, User var3);
}

