/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comments;

import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.event.issue.IssueEventDispatcher;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentComparator;
import com.atlassian.jira.issue.comments.CommentImpl;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.comments.CommentPermissionManager;
import com.atlassian.jira.issue.comments.MutableComment;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.JiraDateUtils;
import com.atlassian.jira.util.ObjectUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilDateTime;

public class DefaultCommentManager
implements CommentManager {
    private final IssueManager issueManager;
    private final ProjectRoleManager projectRoleManager;
    private final CommentPermissionManager commentPermissionManager;
    private final OfBizDelegator delegator;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private static final String COMMENT_ID = "id";
    public static final String COMMENT_ENTITY = "Action";

    public DefaultCommentManager(IssueManager issueManager, ProjectRoleManager projectRoleManager, CommentPermissionManager commentPermissionManager, OfBizDelegator delegator, JiraAuthenticationContext jiraAuthenticationContext) {
        this.issueManager = issueManager;
        this.projectRoleManager = projectRoleManager;
        this.commentPermissionManager = commentPermissionManager;
        this.delegator = delegator;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public ProjectRole getProjectRole(Long projectRoleId) {
        return this.projectRoleManager.getProjectRole(projectRoleId);
    }

    @Override
    public Comment convertToComment(GenericValue gv) {
        return this.convertToComment(gv, this.issueManager.getIssueObject(gv.getLong("issue")));
    }

    @Override
    public Comment getCommentById(Long commentId) {
        return this.getMutableComment(commentId);
    }

    @Override
    public MutableComment getMutableComment(Long commentId) {
        if (commentId == null) {
            throw new IllegalArgumentException("The comment id must not be null.");
        }
        Map fields = EasyMap.build((Object)COMMENT_ID, (Object)commentId);
        GenericValue gv = this.delegator.findByPrimaryKey(COMMENT_ENTITY, fields);
        if (gv != null) {
            return this.convertToComment(gv, this.issueManager.getIssueObject(gv.getLong("issue")));
        }
        return null;
    }

    @Override
    public List<Comment> getCommentsForUser(Issue issue, User user) {
        ArrayList<Comment> visibleComments = new ArrayList<Comment>();
        try {
            List<GenericValue> allComments = this.issueManager.getEntitiesByIssueObject("IssueComments", issue);
            for (GenericValue commentGV : allComments) {
                MutableComment comment = this.convertToComment(commentGV, issue);
                if (!this.commentPermissionManager.hasBrowsePermission(user, comment)) continue;
                visibleComments.add(comment);
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
        Collections.sort(visibleComments, CommentComparator.COMPARATOR);
        return visibleComments;
    }

    @Override
    public List<Comment> getComments(Issue issue) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        try {
            List<GenericValue> allComments = this.issueManager.getEntitiesByIssueObject("IssueComments", issue);
            for (GenericValue allComment : allComments) {
                MutableComment comment = this.convertToComment(allComment, issue);
                comments.add(comment);
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
        Collections.sort(comments, CommentComparator.COMPARATOR);
        return comments;
    }

    @Override
    public Comment create(Issue issue, String author, String body, boolean dispatchEvent) {
        return this.create(issue, author, body, null, null, dispatchEvent);
    }

    @Override
    public Comment create(Issue issue, String author, String body, String groupLevel, Long roleLevelId, boolean dispatchEvent) throws DataAccessException {
        return this.create(issue, author, body, groupLevel, roleLevelId, new Date(), dispatchEvent);
    }

    @Override
    public Comment create(Issue issue, String author, String body, String groupLevel, Long roleLevelId, Date created, boolean dispatchEvent) throws DataAccessException {
        return this.create(issue, author, author, body, groupLevel, roleLevelId, created, created, dispatchEvent);
    }

    @Override
    public Comment create(Issue issue, String author, String updateAuthor, String body, String groupLevel, Long roleLevelId, Date created, Date updated, boolean dispatchEvent) throws DataAccessException {
        return this.create(issue, author, updateAuthor, body, groupLevel, roleLevelId, created, updated, dispatchEvent, true);
    }

    @Override
    public Comment create(Issue issue, String author, String updateAuthor, String body, String groupLevel, Long roleLevelId, Date created, Date updated, boolean dispatchEvent, boolean tweakIssueUpdateDate) throws DataAccessException {
        GenericValue commentGV;
        CommentImpl comment = new CommentImpl(this, author, updateAuthor, body, groupLevel, roleLevelId, created, updated, issue);
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("issue", issue.getId());
        fields.put("type", "comment");
        fields.put("author", comment.getAuthor());
        fields.put("updateauthor", comment.getUpdateAuthor());
        fields.put("body", comment.getBody());
        fields.put("level", comment.getGroupLevel());
        fields.put("rolelevel", comment.getRoleLevelId());
        fields.put("created", new Timestamp(comment.getCreated().getTime()));
        fields.put("updated", new Timestamp(comment.getUpdated().getTime()));
        try {
            commentGV = EntityUtils.createValue(COMMENT_ENTITY, fields);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
        comment.setId(commentGV.getLong(COMMENT_ID));
        if (tweakIssueUpdateDate) {
            IssueFactory issueFactory = ComponentManager.getComponentInstanceOfType(IssueFactory.class);
            MutableIssue mutableIssue = issueFactory.getIssue(issue.getGenericValue());
            mutableIssue.setUpdated(new Timestamp(comment.getUpdated().getTime()));
            issue.store();
        }
        if (dispatchEvent) {
            this.dispatchEvent(EventType.ISSUE_COMMENTED_ID, comment, EasyMap.build((Object)"eventsource", (Object)"action"));
        }
        return comment;
    }

    @Override
    public void update(Comment comment, boolean dispatchEvent) {
        if (comment == null) {
            throw new IllegalArgumentException("Comment must not be null");
        }
        if (comment.getId() == null) {
            throw new IllegalArgumentException("Comment ID must not be null");
        }
        Comment originalComment = this.getCommentById(comment.getId());
        if (originalComment == null) {
            throw new IllegalArgumentException("Can not find a comment in the datastore with id: " + comment.getId());
        }
        if (this.areCommentsEquivalent(originalComment, comment)) {
            return;
        }
        try {
            GenericValue commentGV = this.delegator.findByPrimaryKey(COMMENT_ENTITY, EasyMap.build((Object)COMMENT_ID, (Object)comment.getId()));
            this.populateGenericValueFromComment(comment, commentGV);
            commentGV.store();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
        IssueFactory issueFactory = ComponentManager.getComponentInstanceOfType(IssueFactory.class);
        GenericValue issueGV = comment.getIssue().getGenericValue();
        MutableIssue mutableIssue = issueFactory.getIssue(issueGV);
        mutableIssue.setUpdated(UtilDateTime.nowTimestamp());
        mutableIssue.store();
        if (dispatchEvent) {
            this.dispatchEvent(EventType.ISSUE_COMMENT_EDITED_ID, comment, EasyMap.build((Object)"eventsource", (Object)"action", (Object)"originalcomment", (Object)originalComment));
        }
    }

    @Override
    public ChangeItemBean delete(Comment comment) {
        ChangeItemBean changeItemBean = this.constructChangeItemBeanForCommentDelete(comment);
        this.delegator.removeByAnd(COMMENT_ENTITY, EasyMap.build((Object)COMMENT_ID, (Object)comment.getId(), (Object)"type", (Object)"comment"));
        return changeItemBean;
    }

    @Override
    public boolean isUserCommentAuthor(User user, Comment comment) {
        return this.commentPermissionManager.isUserCommentAuthor(user, comment);
    }

    @Override
    public int swapCommentGroupRestriction(String groupName, String swapGroup) {
        if (groupName == null) {
            throw new IllegalArgumentException("You must provide a non null group name.");
        }
        if (swapGroup == null) {
            throw new IllegalArgumentException("You must provide a non null swap group name.");
        }
        return this.delegator.bulkUpdateByAnd(COMMENT_ENTITY, EasyMap.build((Object)"level", (Object)swapGroup), EasyMap.build((Object)"level", (Object)groupName, (Object)"type", (Object)"comment"));
    }

    @Override
    public long getCountForCommentsRestrictedByGroup(String groupName) {
        if (groupName == null) {
            throw new IllegalArgumentException("You must provide a non null group name.");
        }
        EntityFieldMap condition = new EntityFieldMap(EasyMap.build((Object)"level", (Object)groupName, (Object)"type", (Object)"comment"), EntityOperator.AND);
        List<GenericValue> commentCount = this.delegator.findByCondition("ActionCount", (EntityCondition)condition, EasyList.build((Object)"count"), Collections.EMPTY_LIST);
        if (commentCount != null && commentCount.size() == 1) {
            GenericValue commentCountGV = commentCount.get(0);
            return commentCountGV.getLong("count");
        }
        throw new DataAccessException("Unable to access the count for the Action table");
    }

    ChangeItemBean constructChangeItemBeanForCommentDelete(Comment comment) {
        String groupLevel = comment.getGroupLevel();
        String roleLevel = comment.getRoleLevel() == null ? null : comment.getRoleLevel().getName();
        String actionLevel = groupLevel == null ? roleLevel : groupLevel;
        String message = actionLevel != null ? this.getText("comment.manager.deleted.comment.with.restricted.level", actionLevel) : comment.getBody();
        return new ChangeItemBean("jira", "Comment", message, null);
    }

    void dispatchEvent(Long eventTypeId, Comment comment, Map parameters) {
        User authorUser = UserUtils.getUser(comment.getUpdateAuthor());
        IssueEventDispatcher.dispatchEvent(eventTypeId, comment.getIssue(), authorUser, comment, null, null, parameters);
    }

    private String getText(String key, String param) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key, param);
    }

    private void populateGenericValueFromComment(Comment updatedComment, GenericValue commentGV) {
        commentGV.setString("updateauthor", updatedComment.getUpdateAuthor());
        commentGV.setString("body", updatedComment.getBody());
        commentGV.setString("level", updatedComment.getGroupLevel());
        commentGV.set("rolelevel", (Object)updatedComment.getRoleLevelId());
        commentGV.set("updated", (Object)JiraDateUtils.copyOrCreateTimestampNullsafe(updatedComment.getUpdated()));
    }

    private MutableComment convertToComment(GenericValue gv, Issue issue) {
        Timestamp createdTS = gv.getTimestamp("created");
        Timestamp updatedTS = gv.getTimestamp("updated");
        CommentImpl comment = new CommentImpl(this, gv.getString("author"), gv.getString("updateauthor"), gv.getString("body"), gv.getString("level"), gv.getLong("rolelevel"), JiraDateUtils.copyDateNullsafe(createdTS), JiraDateUtils.copyDateNullsafe(updatedTS), issue);
        comment.setId(gv.getLong(COMMENT_ID));
        return comment;
    }

    private boolean areCommentsEquivalent(Comment comment1, Comment comment2) {
        return ObjectUtils.equalsNullSafe(comment1.getBody(), comment2.getBody()) && ObjectUtils.equalsNullSafe(comment1.getGroupLevel(), comment2.getGroupLevel()) && ObjectUtils.equalsNullSafe(comment1.getRoleLevelId(), comment2.getRoleLevelId());
    }
}

