/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comments;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.comments.MutableComment;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.JiraDateUtils;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class CommentImpl
implements MutableComment {
    private final CommentManager manager;
    private Long id;
    private String author;
    private String body;
    private String groupLevel;
    private Long roleLevelId;
    private Date created;
    private Issue issue;
    private String updateAuthor;
    private Date updated;

    public CommentImpl(CommentManager manager, String author, String updateAuthor, String body, String groupLevel, Long roleLevelId, Date created, Date updated, Issue issue) throws IllegalArgumentException {
        Date createdDate;
        if (StringUtils.isNotBlank((String)groupLevel) && roleLevelId != null) {
            throw new IllegalArgumentException("Cannot specify both grouplevel and rolelevel comment visibility");
        }
        this.manager = manager;
        this.author = author;
        this.updateAuthor = updateAuthor;
        this.body = body == null ? "" : body;
        this.groupLevel = groupLevel;
        this.roleLevelId = roleLevelId;
        this.created = createdDate = JiraDateUtils.copyOrCreateDateNullsafe(created);
        this.updated = updated == null ? createdDate : updated;
        this.issue = issue;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public User getAuthorUser() {
        return UserUtils.getUserEvenWhenUnknown(this.getAuthor());
    }

    @Override
    public String getAuthorFullName() {
        String author = this.getAuthor();
        return author == null ? null : this.getFullNameForUsername(author);
    }

    private String getFullNameForUsername(String author) {
        return UserUtils.getUserEvenWhenUnknown(author).getDisplayName();
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public Date getCreated() {
        return JiraDateUtils.copyDateNullsafe(this.created);
    }

    @Override
    public String getGroupLevel() {
        return this.groupLevel;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getUpdateAuthor() {
        return this.updateAuthor;
    }

    @Override
    public User getUpdateAuthorUser() {
        return UserUtils.getUserEvenWhenUnknown(this.getUpdateAuthor());
    }

    @Override
    public String getUpdateAuthorFullName() {
        String updateAuthor = this.getUpdateAuthor();
        return updateAuthor == null ? null : this.getFullNameForUsername(updateAuthor);
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    @Override
    public void setAuthor(String author) {
        this.author = author;
    }

    @Override
    public void setBody(String body) {
        this.body = body;
    }

    @Override
    public void setGroupLevel(String groupLevel) {
        this.groupLevel = groupLevel;
    }

    @Override
    public void setRoleLevelId(Long roleLevelId) {
        this.roleLevelId = roleLevelId;
    }

    @Override
    public void setCreated(Date created) {
        this.created = created;
    }

    @Override
    public void setUpdateAuthor(String updateAuthor) {
        this.updateAuthor = updateAuthor;
    }

    @Override
    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    void setId(Long id) {
        this.id = id;
    }

    @Override
    public Long getRoleLevelId() {
        return this.roleLevelId;
    }

    @Override
    public ProjectRole getRoleLevel() {
        return this.roleLevelId == null ? null : this.manager.getProjectRole(this.roleLevelId);
    }

    @Override
    public Issue getIssue() {
        return this.issue;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CommentImpl)) {
            return false;
        }
        CommentImpl comment = (CommentImpl)obj;
        if (this.id != null ? !this.id.equals(comment.id) : comment.id != null) {
            return false;
        }
        if (!this.author.equals(comment.author)) {
            return false;
        }
        if (!this.created.equals(comment.created)) {
            return false;
        }
        if (!this.body.equals(comment.body)) {
            return false;
        }
        if (this.roleLevelId != null ? !this.roleLevelId.equals(comment.roleLevelId) : comment.roleLevelId != null) {
            return false;
        }
        if (this.groupLevel != null ? !this.groupLevel.equals(comment.groupLevel) : comment.groupLevel != null) {
            return false;
        }
        if (this.updateAuthor != null ? !this.updateAuthor.equals(comment.updateAuthor) : comment.updateAuthor != null) {
            return false;
        }
        return !(this.updated != null ? !this.updated.equals(comment.updated) : comment.updated != null);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }
}

