/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.jira.issue.attachment.Path;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;

public class AttachmentZipKit {
    private static final Logger log = Logger.getLogger(AttachmentZipKit.class);

    public boolean isZip(File file) {
        if (file == null) {
            return false;
        }
        try {
            ZipFile zipFile = new ZipFile(file);
            zipFile.close();
        }
        catch (ZipException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public ZipEntryInputStream extractFile(File zipFile, long entryIndex) throws IOException {
        if (!this.isZip(zipFile)) {
            throw new ZipException("This is not a zipFile" + zipFile);
        }
        int i = 0;
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(zipFile));
        ZipEntry entry = zipInputStream.getNextEntry();
        while (entry != null && (long)i < entryIndex) {
            entry = zipInputStream.getNextEntry();
            ++i;
        }
        if (entry != null && (long)i == entryIndex) {
            return new ZipEntryInputStream(zipInputStream, entry);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttachmentZipEntries listEntries(File zipFile, int maxEntries, FileCriteria criteria) throws IOException {
        AttachmentZipEntriesImpl attachmentZipEntriesImpl;
        ZipFile zf = new ZipFile(zipFile);
        try {
            List<AttachmentZipEntryImpl> list = new ArrayList<AttachmentZipEntryImpl>();
            int currentEntry = 0;
            Enumeration<? extends ZipEntry> enumeration = zf.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (criteria.matches(zipEntry)) {
                    list.add(new AttachmentZipEntryImpl(currentEntry, zipEntry));
                }
                ++currentEntry;
            }
            int totalNumberOfEntriesAvailable = list.size();
            boolean hasMore = false;
            if (maxEntries >= 0 && list.size() > maxEntries) {
                hasMore = true;
                list = list.subList(0, maxEntries);
            }
            attachmentZipEntriesImpl = new AttachmentZipEntriesImpl(list, totalNumberOfEntriesAvailable, hasMore);
        }
        catch (Throwable throwable) {
            try {
                zf.close();
            }
            catch (IOException e) {
                log.error((Object)String.format("JIRA was not able to close the zip file: '%s' while / after listing its entries. An IOException was thrown.", zipFile.getPath()));
            }
            throw throwable;
        }
        try {
            zf.close();
        }
        catch (IOException e) {
            log.error((Object)String.format("JIRA was not able to close the zip file: '%s' while / after listing its entries. An IOException was thrown.", zipFile.getPath()));
        }
        return attachmentZipEntriesImpl;
    }

    private static class AttachmentZipEntryImpl
    implements AttachmentZipEntry {
        private final int entryIndex;
        private final int directoryDepth;
        private final ZipEntry zipEntry;

        public AttachmentZipEntryImpl(int entryIndex, ZipEntry zipEntry) {
            this.entryIndex = entryIndex;
            this.zipEntry = zipEntry;
            this.directoryDepth = this.calcDepth(zipEntry.getName());
        }

        private int calcDepth(String name) {
            File f = new File(name);
            int i = 0;
            while ((f = f.getParentFile()) != null) {
                ++i;
            }
            return i;
        }

        @Override
        public long getEntryIndex() {
            return this.entryIndex;
        }

        @Override
        public String getName() {
            return this.zipEntry.getName();
        }

        @Override
        public String getAbbreviatedName() {
            return new Path(this.getName()).abbreviate(40).getPath();
        }

        @Override
        public String getExtension() {
            String name = new File(this.getName()).getName();
            int index = name.lastIndexOf(".");
            if (index > 0) {
                return name.substring(index);
            }
            return "";
        }

        @Override
        public long getSize() {
            return this.zipEntry.getSize();
        }

        @Override
        public boolean isDirectory() {
            return this.zipEntry.isDirectory();
        }

        @Override
        public int getDirectoryDepth() {
            return this.directoryDepth;
        }

        @Override
        public Date getModifiedDate() {
            return new Date(this.zipEntry.getTime());
        }

        public String toString() {
            return super.toString() + "-idx:" + this.getEntryIndex() + "-name:" + this.getName() + "-dir:" + this.isDirectory() + "-size:" + this.getSize();
        }
    }

    private static class AttachmentZipEntriesImpl
    implements AttachmentZipEntries {
        private final boolean moreAvailable;
        private final int totalNumberOfEntriesAvailable;
        private final List<AttachmentZipEntry> list;

        private AttachmentZipEntriesImpl(List<AttachmentZipEntry> list, int totalNumberOfEntriesAvailable, boolean moreAvailable) {
            this.moreAvailable = moreAvailable;
            this.totalNumberOfEntriesAvailable = totalNumberOfEntriesAvailable;
            this.list = list;
        }

        @Override
        public boolean isMoreAvailable() {
            return this.moreAvailable;
        }

        @Override
        public int getTotalNumberOfEntriesAvailable() {
            return this.totalNumberOfEntriesAvailable;
        }

        @Override
        public List<AttachmentZipEntry> getList() {
            return Collections.unmodifiableList(this.list);
        }
    }

    public static enum FileCriteria {
        ONLY_FILES{

            @Override
            boolean matches(ZipEntry zipEntry) {
                return !zipEntry.isDirectory();
            }
        }
        ,
        ONLY_DIRECTORIES{

            @Override
            boolean matches(ZipEntry zipEntry) {
                return zipEntry.isDirectory();
            }
        }
        ,
        ALL{

            @Override
            boolean matches(ZipEntry zipEntry) {
                return true;
            }
        };


        abstract boolean matches(ZipEntry var1);
    }

    public static class ZipEntryInputStream
    extends InputStream {
        private final InputStream inputStream;
        private final ZipEntry zipEntry;

        private ZipEntryInputStream(InputStream inputStream, ZipEntry zipEntry) {
            this.inputStream = inputStream;
            this.zipEntry = zipEntry;
        }

        public ZipEntry getZipEntry() {
            return this.zipEntry;
        }

        @Override
        public int read() throws IOException {
            return this.inputStream.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.inputStream.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.inputStream.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.inputStream.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.inputStream.available();
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }

        @Override
        public void mark(int readlimit) {
            this.inputStream.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.inputStream.reset();
        }

        @Override
        public boolean markSupported() {
            return this.inputStream.markSupported();
        }
    }

    public static interface AttachmentZipEntry {
        public long getEntryIndex();

        public String getName();

        public String getAbbreviatedName();

        public String getExtension();

        public long getSize();

        public boolean isDirectory();

        public int getDirectoryDepth();

        public Date getModifiedDate();
    }

    public static interface AttachmentZipEntries {
        public boolean isMoreAvailable();

        public int getTotalNumberOfEntriesAvailable();

        public List<AttachmentZipEntry> getList();
    }
}

