/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.gzipfilter.org.apache.commons.lang.StringEscapeUtils;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.LocaleParser;
import com.atlassian.jira.web.bean.I18nBean;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class TextIssueConstant
implements IssueConstant {
    private static final Logger log = Logger.getLogger(TextIssueConstant.class);
    private static final Long SEQUENCE = new Long(0L);
    private String nameKey;
    private String descriptionKey;
    private String iconUrl;
    private final JiraAuthenticationContext authenticationContext;

    public TextIssueConstant(String nameKey, String descriptionKey, String iconUrl, JiraAuthenticationContext authenticationContext) {
        this.nameKey = nameKey;
        this.descriptionKey = descriptionKey;
        this.iconUrl = iconUrl;
        this.authenticationContext = authenticationContext;
    }

    @Override
    public GenericValue getGenericValue() {
        this.handleException();
        return null;
    }

    @Override
    public String getId() {
        return "-1";
    }

    @Override
    public String getName() {
        return this.getI18n().getText(this.nameKey);
    }

    @Override
    public void setName(String name) {
        this.handleException();
    }

    @Override
    public String getDescription() {
        return this.getI18n().getText(this.descriptionKey);
    }

    @Override
    public void setDescription(String description) {
        this.handleException();
    }

    @Override
    public Long getSequence() {
        return SEQUENCE;
    }

    @Override
    public void setSequence(Long sequence) {
        this.handleException();
    }

    @Override
    public String getIconUrl() {
        return this.iconUrl;
    }

    @Override
    public String getIconUrlHtml() {
        return StringEscapeUtils.escapeHtml((String)this.getIconUrl());
    }

    @Override
    public void setIconUrl(String iconURL) {
        this.handleException();
    }

    @Override
    public String getNameTranslation() {
        return this.getI18n().getText(this.nameKey);
    }

    @Override
    public String getDescTranslation() {
        return this.getI18n().getText(this.descriptionKey);
    }

    @Override
    public String getNameTranslation(String locale) {
        return new I18nBean(LocaleParser.parseLocale(locale)).getText(this.nameKey);
    }

    @Override
    public String getDescTranslation(String locale) {
        return new I18nBean(LocaleParser.parseLocale(locale)).getText(this.descriptionKey);
    }

    @Override
    public String getNameTranslation(I18nHelper i18n) {
        return new I18nBean(i18n.getLocale()).getText(this.nameKey);
    }

    @Override
    public String getDescTranslation(I18nHelper i18n) {
        return new I18nBean(i18n.getLocale()).getText(this.descriptionKey);
    }

    @Override
    public void setTranslation(String translatedName, String translatedDesc, String issueConstantPrefix, Locale locale) {
        this.handleException();
    }

    @Override
    public void deleteTranslation(String issueConstantPrefix, Locale locale) {
        this.handleException();
    }

    @Override
    public PropertySet getPropertySet() {
        this.handleException();
        return null;
    }

    public int compareTo(Object o) {
        return 0;
    }

    private I18nHelper getI18n() {
        return this.authenticationContext.getI18nHelper();
    }

    private void handleException() {
        log.warn((Object)"Unable to call method. Method not implemented");
        throw new IllegalArgumentException("Unable to call method. Method not implemented");
    }
}

