/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.migration.WorkflowMigrationMapping;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.spi.WorkflowStore;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class IssueVerifier {
    private static final Logger log = Logger.getLogger(IssueVerifier.class);

    public ErrorCollection verifyIssue(Issue issue, Map workflowMigrationMapping, boolean checkWorkflowIntegrity) {
        return this.verifyIssue(issue.getGenericValue(), (Map<String, String>)workflowMigrationMapping, checkWorkflowIntegrity);
    }

    public ErrorCollection verifyIssue(GenericValue issue, Map<String, String> workflowMigrationMapping, boolean checkWorkflowIntegrity) {
        ConstantsManager constantsManager = ComponentAccessor.getConstantsManager();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        try {
            this.checkIssueDetails(issue, errorCollection, constantsManager, checkWorkflowIntegrity);
            String statusId = issue.getString("status");
            String targetStatusId = workflowMigrationMapping.get(statusId);
            GenericValue targetStatus = constantsManager.getStatus(targetStatusId);
            if (targetStatus == null) {
                errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.unable.to.determine.target.status", issue.getString("key")));
                log.error((Object)("Unable to determine the target status for issue '" + issue.getString("key") + "'."));
            }
        }
        catch (Exception e) {
            errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.encountered.error.processing.issue", issue.getString("key")));
            log.error((Object)("Encountered an error processing the issue '" + issue.getString("key") + "'."), (Throwable)e);
        }
        return errorCollection;
    }

    public ErrorCollection verifyForMigration(GenericValue issue, List<GenericValue> typesNeedingMigration, WorkflowMigrationMapping workflowMigrationMapping, boolean checkWorkflowIntegrity) {
        ConstantsManager constantsManager = ComponentAccessor.getConstantsManager();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        try {
            this.checkIssueDetails(issue, errorCollection, constantsManager, checkWorkflowIntegrity);
            GenericValue currentIssueType = constantsManager.getIssueType(issue.getString("type"));
            GenericValue targetStatus = null;
            targetStatus = typesNeedingMigration.contains(currentIssueType) ? workflowMigrationMapping.getTargetStatus(issue) : constantsManager.getStatus(issue.getString("status"));
            if (targetStatus == null) {
                errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.unable.to.determine.target.status", "'" + issue.getString("key") + "'"));
                log.error((Object)("Unable to determine the target status for issue '" + issue.getString("key") + "'."));
            }
        }
        catch (Exception e) {
            errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.encountered.error.processing.issue", "'" + issue.getString("key") + "'"));
            log.error((Object)("Encountered an error processing the issue '" + issue.getString("key") + "'."), (Throwable)e);
        }
        return errorCollection;
    }

    protected void checkIssueDetails(GenericValue issue, ErrorCollection errorCollection, ConstantsManager constantsManager, boolean checkWorkflowIntegrity) throws WorkflowException {
        String issueTypeId;
        Long originalWfIdString;
        List<GenericValue> linkedStatuses = null;
        JiraWorkflow originalWorkflow = this.getWorkflowManager().getWorkflow(issue);
        if (originalWorkflow == null) {
            errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.unable.to.determine.workflow", "'" + issue.getString("key") + "'"));
            log.error((Object)("Unable to determine the current workflow for issue '" + issue.getString("key") + "'."));
        }
        if ((originalWfIdString = issue.getLong("workflowId")) == null) {
            errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.unable.to.determine.workflow.entry", "'" + issue.getString("key") + "'"));
            log.error((Object)("Unable to determine the current workflow entry for issue '" + issue.getString("key") + "'."));
        }
        if ((issueTypeId = issue.getString("type")) == null || constantsManager.getIssueType(issue.getString("type")) == null) {
            errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.unable.to.determine.current.issue.type", "'" + issue.getString("key") + "'"));
            log.error((Object)("Unable to determine the current issue type for issue '" + issue.getString("key") + "'."));
        } else if (!constantsManager.getAllIssueTypes().contains(constantsManager.getIssueType(issue.getString("type")))) {
            errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.invalid.issue.type", "'" + issue.getString("key") + "'"));
            log.error((Object)("Issue '" + issue.getString("key") + "'  does not have a valid issue type."));
        }
        GenericValue originalStatus = ComponentAccessor.getConstantsManager().getStatus(issue.getString("status"));
        if (originalStatus == null) {
            errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.unable.to.determine.status", "'" + issue.getString("key") + "'"));
            log.error((Object)("Unable to determine the current status for issue '" + issue.getString("key") + "'."));
        }
        if (checkWorkflowIntegrity) {
            if (originalStatus != null) {
                if (linkedStatuses == null) {
                    linkedStatuses = this.getWorkflowManager().getWorkflow(issue).getLinkedStatuses();
                }
                if (!linkedStatuses.contains(originalStatus)) {
                    errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.issue.incorrect.association", "'" + issue.getString("key") + "'", "'" + originalStatus.getString("name") + "'"));
                    log.error((Object)("The issue '" + issue.getString("key") + "' is incorrectly associated with the status '" + originalStatus.getString("name") + "'."));
                }
            }
            try {
                WorkflowStore store = this.getWorkflowManager().getStore();
                List stepDescriptors = originalWorkflow.getDescriptor().getSteps();
                for (StepDescriptor stepDescriptor : stepDescriptors) {
                    List workflowSteps;
                    Map stepAttributes = stepDescriptor.getMetaAttributes();
                    GenericValue statusGV = ComponentAccessor.getConstantsManager().getStatus((String)stepAttributes.get("jira.status.id"));
                    if (!originalStatus.equals((Object)statusGV)) continue;
                    List actions = stepDescriptor.getActions();
                    if (!actions.isEmpty() && (workflowSteps = store.findCurrentSteps(originalWfIdString.longValue())).isEmpty()) {
                        errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.unable.to.determine.current.step", "'" + issue.getString("key") + "'"));
                        log.error((Object)("Unable to determine the current step for issue for issue '" + issue.getString("key") + "'."));
                    }
                    break;
                }
            }
            catch (StoreException se) {
                errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.error.accessing.workflow.store", "'" + issue.getString("key") + "'"));
                log.error((Object)("Error accessing workflow store to determine the current step for issue '" + issue.getString("key") + "'."));
            }
        }
    }

    protected I18nHelper getI18nBean() {
        return ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
    }

    private WorkflowManager getWorkflowManager() {
        return ComponentAccessor.getWorkflowManager();
    }
}

