/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.core.util.InvalidDurationException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CommentVisibility;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class IssueInputParametersImpl
implements IssueInputParameters {
    private static final Logger log = Logger.getLogger(IssueInputParametersImpl.class);
    private final Map<String, String[]> actionParameters = new HashMap<String, String[]>();
    private Map<String, Object> fieldValuesHolder;
    private Collection<String> providedFields;
    private boolean retainExistingValuesWhenParameterNotProvided = true;
    private boolean applyDefaultValuesWhenParameterNotProvided = false;

    public IssueInputParametersImpl() {
        this(null);
    }

    public IssueInputParametersImpl(Map<String, String[]> actionParameters) {
        if (actionParameters != null) {
            this.actionParameters.putAll(actionParameters);
        }
    }

    @Override
    public IssueInputParameters setProjectId(Long projectId) {
        if (projectId != null) {
            this.actionParameters.put(SystemSearchConstants.forProject().getUrlParameter(), new String[]{projectId.toString()});
        }
        return this;
    }

    @Override
    public Long getProjectId() {
        return this.getSingleLongValueFromParameter(SystemSearchConstants.forProject().getUrlParameter());
    }

    @Override
    public IssueInputParameters setIssueTypeId(String issueTypeId) {
        if (issueTypeId != null) {
            this.actionParameters.put(SystemSearchConstants.forIssueType().getFieldId(), new String[]{issueTypeId});
        }
        return this;
    }

    @Override
    public String getIssueTypeId() {
        return this.getSingleValueFromParameters(SystemSearchConstants.forIssueType().getFieldId());
    }

    @Override
    public IssueInputParameters setPriorityId(String priorityId) {
        if (priorityId != null) {
            this.actionParameters.put(SystemSearchConstants.forPriority().getFieldId(), new String[]{priorityId});
        } else {
            this.actionParameters.put(SystemSearchConstants.forPriority().getFieldId(), null);
        }
        return this;
    }

    @Override
    public String getPriorityId() {
        return this.getSingleValueFromParameters(SystemSearchConstants.forPriority().getFieldId());
    }

    @Override
    public IssueInputParameters setResolutionId(String resolutionId) {
        if (resolutionId != null) {
            this.actionParameters.put(SystemSearchConstants.forResolution().getFieldId(), new String[]{resolutionId});
        } else {
            this.actionParameters.put(SystemSearchConstants.forResolution().getFieldId(), null);
        }
        return this;
    }

    @Override
    public String getResolutionId() {
        return this.getSingleValueFromParameters(SystemSearchConstants.forResolution().getFieldId());
    }

    @Override
    public IssueInputParameters setStatusId(String statusId) {
        if (statusId != null) {
            this.actionParameters.put(SystemSearchConstants.forStatus().getFieldId(), new String[]{statusId});
        } else {
            this.actionParameters.put(SystemSearchConstants.forStatus().getFieldId(), null);
        }
        return this;
    }

    @Override
    public String getStatusId() {
        return this.getSingleValueFromParameters(SystemSearchConstants.forStatus().getFieldId());
    }

    @Override
    public IssueInputParameters setSummary(String summary) {
        if (summary != null) {
            this.actionParameters.put(SystemSearchConstants.forSummary().getFieldId(), new String[]{summary});
        } else {
            this.actionParameters.put(SystemSearchConstants.forSummary().getFieldId(), null);
        }
        return this;
    }

    @Override
    public String getSummary() {
        return this.getSingleValueFromParameters(SystemSearchConstants.forSummary().getFieldId());
    }

    @Override
    public IssueInputParameters setDescription(String description) {
        if (description != null) {
            this.actionParameters.put(SystemSearchConstants.forDescription().getFieldId(), new String[]{description});
        } else {
            this.actionParameters.put(SystemSearchConstants.forDescription().getFieldId(), null);
        }
        return this;
    }

    @Override
    public String getDescription() {
        return this.getSingleValueFromParameters(SystemSearchConstants.forDescription().getFieldId());
    }

    @Override
    public IssueInputParameters setEnvironment(String environment) {
        if (environment != null) {
            this.actionParameters.put(SystemSearchConstants.forEnvironment().getFieldId(), new String[]{environment});
        } else {
            this.actionParameters.put(SystemSearchConstants.forEnvironment().getFieldId(), null);
        }
        return this;
    }

    @Override
    public String getEnvironment() {
        return this.getSingleValueFromParameters(SystemSearchConstants.forEnvironment().getFieldId());
    }

    @Override
    public IssueInputParameters setAssigneeId(String assigneeId) {
        if (assigneeId != null) {
            this.actionParameters.put(SystemSearchConstants.forAssignee().getFieldId(), new String[]{assigneeId});
        } else {
            this.actionParameters.put(SystemSearchConstants.forAssignee().getFieldId(), null);
        }
        return this;
    }

    @Override
    public String getAssigneeId() {
        return this.getSingleValueFromParameters(SystemSearchConstants.forAssignee().getFieldId());
    }

    @Override
    public IssueInputParameters setReporterId(String reporterId) {
        if (reporterId != null) {
            this.actionParameters.put(SystemSearchConstants.forReporter().getFieldId(), new String[]{reporterId});
        } else {
            this.actionParameters.put(SystemSearchConstants.forReporter().getFieldId(), null);
        }
        return this;
    }

    @Override
    public String getReporterId() {
        return this.getSingleValueFromParameters(SystemSearchConstants.forReporter().getFieldId());
    }

    @Override
    public IssueInputParameters setComponentIds(Long ... componentIds) {
        this.actionParameters.put(SystemSearchConstants.forComponent().getFieldId(), this.convertLongArrayToStringArray(componentIds));
        return this;
    }

    @Override
    public Long[] getComponentIds() {
        return this.getMultipleLongValuesFromParameters(SystemSearchConstants.forComponent().getFieldId());
    }

    @Override
    public IssueInputParameters setFixVersionIds(Long ... fixVersionIds) {
        this.actionParameters.put(SystemSearchConstants.forFixForVersion().getFieldId(), this.convertLongArrayToStringArray(fixVersionIds));
        return this;
    }

    @Override
    public Long[] getFixVersionIds() {
        return this.getMultipleLongValuesFromParameters(SystemSearchConstants.forFixForVersion().getFieldId());
    }

    @Override
    public IssueInputParameters setAffectedVersionIds(Long ... affectedVersionIds) {
        this.actionParameters.put(SystemSearchConstants.forAffectedVersion().getFieldId(), this.convertLongArrayToStringArray(affectedVersionIds));
        return this;
    }

    @Override
    public Long[] getAffectedVersionIds() {
        return this.getMultipleLongValuesFromParameters(SystemSearchConstants.forAffectedVersion().getFieldId());
    }

    @Override
    public IssueInputParameters setDueDate(String dueDate) {
        if (dueDate != null) {
            this.actionParameters.put(SystemSearchConstants.forDueDate().getFieldId(), new String[]{dueDate});
        } else {
            this.actionParameters.put(SystemSearchConstants.forDueDate().getFieldId(), null);
        }
        return this;
    }

    @Override
    public String getDueDate() {
        return this.getSingleValueFromParameters(SystemSearchConstants.forDueDate().getFieldId());
    }

    @Override
    public IssueInputParameters setResolutionDate(String resolutionDate) {
        if (resolutionDate != null) {
            this.actionParameters.put(SystemSearchConstants.forResolutionDate().getFieldId(), new String[]{resolutionDate});
        } else {
            this.actionParameters.put(SystemSearchConstants.forResolutionDate().getFieldId(), null);
        }
        return this;
    }

    @Override
    public String getResolutionDate() {
        return this.getSingleValueFromParameters(SystemSearchConstants.forResolutionDate().getFieldId());
    }

    @Override
    public IssueInputParameters setSecurityLevelId(Long securityLevelId) {
        if (securityLevelId != null) {
            this.actionParameters.put(SystemSearchConstants.forSecurityLevel().getFieldId(), new String[]{securityLevelId.toString()});
        } else {
            this.actionParameters.put(SystemSearchConstants.forSecurityLevel().getFieldId(), null);
        }
        return this;
    }

    @Override
    public Long getSecurityLevelId() {
        return this.getSingleLongValueFromParameter(SystemSearchConstants.forSecurityLevel().getFieldId());
    }

    @Override
    public IssueInputParameters setOriginalEstimate(Long originalEstimate) {
        String originalEstimateString = originalEstimate != null ? String.valueOf(originalEstimate) : null;
        return this.setOriginalEstimate(originalEstimateString);
    }

    @Override
    public IssueInputParameters setOriginalEstimate(String originalEstimate) {
        if (this.isInLegacyTimetrackingMode()) {
            this.actionParameters.put("timetracking", new String[]{originalEstimate});
        } else {
            this.actionParameters.put("timetracking_targetsubfield", new String[]{"timetracking_originalestimate"});
            this.actionParameters.put("timetracking_originalestimate", new String[]{originalEstimate});
            this.actionParameters.put("timetracking_remainingestimate", null);
            this.actionParameters.put("timetracking", new String[0]);
        }
        return this;
    }

    @Override
    public IssueInputParameters setRemainingEstimate(Long remainingEstimate) {
        String remainingEstimateString = remainingEstimate != null ? String.valueOf(remainingEstimate) : null;
        return this.setRemainingEstimate(remainingEstimateString);
    }

    @Override
    public IssueInputParameters setRemainingEstimate(String remainingEstimate) {
        if (this.isInLegacyTimetrackingMode()) {
            this.actionParameters.put("timetracking", new String[]{remainingEstimate});
        } else {
            this.actionParameters.put("timetracking_targetsubfield", new String[]{"timetracking_remainingestimate"});
            this.actionParameters.put("timetracking_originalestimate", null);
            this.actionParameters.put("timetracking_remainingestimate", new String[]{remainingEstimate});
            this.actionParameters.put("timetracking", new String[0]);
        }
        return this;
    }

    @Override
    public IssueInputParameters setOriginalAndRemainingEstimate(String originalEstimate, String remainingEstimate) {
        if (this.isInLegacyTimetrackingMode()) {
            return this;
        }
        this.actionParameters.put("timetracking_remainingestimate", new String[]{remainingEstimate});
        this.actionParameters.put("timetracking_originalestimate", new String[]{originalEstimate});
        this.actionParameters.put("timetracking", new String[0]);
        return this;
    }

    @Override
    public IssueInputParameters setOriginalAndRemainingEstimate(Long originalEstimate, Long remainingEstimate) {
        String originalEstimateString = originalEstimate != null ? String.valueOf(originalEstimate) : null;
        String remainingEstimateString = remainingEstimate != null ? String.valueOf(remainingEstimate) : null;
        return this.setOriginalAndRemainingEstimate(originalEstimateString, remainingEstimateString);
    }

    @Override
    public Long getOriginalEstimate() {
        try {
            String originalEstimateAsString = this.getOriginalEstimateAsDurationString();
            if (originalEstimateAsString != null) {
                return this.convertDurationToMins(originalEstimateAsString);
            }
            return null;
        }
        catch (InvalidDurationException e) {
            log.error((Object)"Error occurred while retrieving the original estimate. You have probably set a value for the original estimate that cannot be parsed into a valid duration string.");
            throw new RuntimeException(e);
        }
    }

    @Override
    public Long getRemainingEstimate() {
        try {
            String remainingEstimateAsString = this.getRemainingEstimateAsDurationString();
            if (remainingEstimateAsString != null) {
                return this.convertDurationToMins(remainingEstimateAsString);
            }
            return null;
        }
        catch (InvalidDurationException e) {
            log.error((Object)"Error occurred while retrieving the remaining estimate. You have probably set a value for the remaining estimate that cannot be parsed into a valid duration string.");
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getRemainingEstimateAsDurationString() {
        if (this.isInLegacyTimetrackingMode()) {
            return this.getSingleValueFromParameters("timetracking");
        }
        return this.getSingleValueFromParameters("timetracking_remainingestimate");
    }

    @Override
    public String getOriginalEstimateAsDurationString() {
        if (this.isInLegacyTimetrackingMode()) {
            return this.getSingleValueFromParameters("timetracking");
        }
        return this.getSingleValueFromParameters("timetracking_originalestimate");
    }

    @Override
    public IssueInputParameters setTimeSpent(Long timeSpent) {
        if (timeSpent != null) {
            this.actionParameters.put(SystemSearchConstants.forTimeSpent().getFieldId(), new String[]{timeSpent.toString()});
        } else {
            this.actionParameters.put(SystemSearchConstants.forTimeSpent().getFieldId(), null);
        }
        return this;
    }

    @Override
    public Long getTimeSpent() {
        return this.getSingleLongValueFromParameter(SystemSearchConstants.forTimeSpent().getFieldId());
    }

    @Override
    public IssueInputParameters addCustomFieldValue(Long customFieldId, String ... values) {
        if (customFieldId != null) {
            this.actionParameters.put("customfield_" + customFieldId, values);
        }
        return this;
    }

    @Override
    public IssueInputParameters addCustomFieldValue(String fullCustomFieldKey, String ... values) {
        if (fullCustomFieldKey != null) {
            this.actionParameters.put(fullCustomFieldKey, values);
        }
        return this;
    }

    @Override
    public boolean retainExistingValuesWhenParameterNotProvided() {
        return this.retainExistingValuesWhenParameterNotProvided;
    }

    @Override
    public void setRetainExistingValuesWhenParameterNotProvided(boolean retain) {
        this.retainExistingValuesWhenParameterNotProvided = retain;
    }

    @Override
    public boolean applyDefaultValuesWhenParameterNotProvided() {
        return this.applyDefaultValuesWhenParameterNotProvided;
    }

    @Override
    public void setApplyDefaultValuesWhenParameterNotProvided(boolean applyDefaultValuesWhenParameterNotProvided) {
        this.applyDefaultValuesWhenParameterNotProvided = applyDefaultValuesWhenParameterNotProvided;
    }

    @Override
    public String[] getCustomFieldValue(Long customFieldId) {
        Assertions.notNull("customFieldId", customFieldId);
        return this.actionParameters.get("customfield_" + customFieldId);
    }

    @Override
    public String[] getCustomFieldValue(String fullCustomFieldKey) {
        return this.actionParameters.get(fullCustomFieldKey);
    }

    @Override
    public String getCommentValue() {
        return this.getSingleValueFromParameters(SystemSearchConstants.forComments().getFieldId());
    }

    @Override
    public IssueInputParameters setComment(String comment) {
        if (comment != null) {
            this.actionParameters.put(SystemSearchConstants.forComments().getFieldId(), new String[]{comment});
        }
        return this;
    }

    @Override
    public IssueInputParameters setComment(String comment, Long projectRoleId) {
        if (comment != null) {
            this.actionParameters.put(SystemSearchConstants.forComments().getFieldId(), new String[]{comment});
        }
        if (projectRoleId != null) {
            this.actionParameters.put("commentLevel", new String[]{CommentVisibility.getCommentLevelFromLevels(null, projectRoleId)});
        }
        return this;
    }

    @Override
    public IssueInputParameters setComment(String comment, String groupId) {
        if (comment != null) {
            this.actionParameters.put(SystemSearchConstants.forComments().getFieldId(), new String[]{comment});
        }
        if (groupId != null) {
            this.actionParameters.put("commentLevel", new String[]{CommentVisibility.getCommentLevelFromLevels(groupId, null)});
        }
        return this;
    }

    @Override
    public Map<String, String[]> getActionParameters() {
        return this.actionParameters;
    }

    @Override
    public void setFieldValuesHolder(Map<String, Object> fieldValuesHolder) {
        this.fieldValuesHolder = fieldValuesHolder;
    }

    @Override
    public Map<String, Object> getFieldValuesHolder() {
        if (this.fieldValuesHolder == null) {
            return Collections.emptyMap();
        }
        return this.fieldValuesHolder;
    }

    @Override
    public Collection<String> getProvidedFields() {
        return this.providedFields;
    }

    @Override
    public void setProvidedFields(Collection<String> providedFields) {
        this.providedFields = providedFields;
    }

    @Override
    public boolean isFieldSet(String fieldId) {
        return this.actionParameters.containsKey(fieldId) && !this.isObjectEmpty(this.actionParameters.get(fieldId));
    }

    @Override
    public boolean isFieldPresent(String fieldId) {
        return this.actionParameters.containsKey(fieldId);
    }

    private Long[] getMultipleLongValuesFromParameters(String key) {
        String[] idStrs = this.actionParameters.get(key);
        if (idStrs != null) {
            try {
                Long[] ids = new Long[idStrs.length];
                for (int i = 0; i < idStrs.length; ++i) {
                    String idStr = idStrs[i];
                    ids[i] = new Long(idStr);
                }
                return ids;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private Long getSingleLongValueFromParameter(String key) {
        try {
            String isStr = this.getSingleValueFromParameters(key);
            if (isStr != null) {
                return new Long(isStr);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private String getSingleValueFromParameters(String key) {
        String[] strings = this.actionParameters.get(key);
        if (strings != null && strings.length == 1) {
            return strings[0];
        }
        return null;
    }

    private String[] convertLongArrayToStringArray(Long[] longs) {
        if (longs == null) {
            return null;
        }
        String[] strings = new String[longs.length];
        for (int i = 0; i < longs.length; ++i) {
            Long id = longs[i];
            strings[i] = id.toString();
        }
        return strings;
    }

    boolean isObjectEmpty(Object value) {
        Object[] objects;
        if (value == null) {
            return true;
        }
        if (value instanceof Object[] && ((objects = (Object[])value).length == 0 || objects.length == 1 && objects[0] == null)) {
            return true;
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        if (value instanceof CustomFieldParams) {
            return ((CustomFieldParams)value).isEmpty();
        }
        return false;
    }

    @VisibleForTesting
    boolean isInLegacyTimetrackingMode() {
        return this.getApplicationProperties().getOption("jira.timetracking.estimates.legacy.behaviour");
    }

    @VisibleForTesting
    Long convertDurationToMins(String duration) throws InvalidDurationException {
        return this.getJiraDurationUtils().parseDuration(duration, this.getAuthenticationContext().getLocale());
    }

    private ApplicationProperties getApplicationProperties() {
        return ComponentAccessor.getApplicationProperties();
    }

    private JiraDurationUtils getJiraDurationUtils() {
        return ComponentAccessor.getComponentOfType(JiraDurationUtils.class);
    }

    private JiraAuthenticationContext getAuthenticationContext() {
        return ComponentAccessor.getComponentOfType(JiraAuthenticationContext.class);
    }
}

