/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.AbstractIssue;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comparator.VersionComparator;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.LabelManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.user.util.UserManager;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class IssueImpl
extends AbstractIssue
implements MutableIssue {
    private final ProjectManager projectManager;
    private final VersionManager versionManager;
    private final LabelManager labelManager;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final SubTaskManager subTaskManager;
    private final ProjectComponentManager projectComponentManager;
    private final UserManager userManager;
    private GenericValue genericValue;
    private Long projectId;
    private String key;
    private String issueTypeId;
    private String summary;
    private String description;
    private String environment;
    private String assigneeId;
    private String reporterId;
    private Timestamp created;
    private Timestamp updated;
    private Timestamp dueDate;
    private Timestamp resolutionDate;
    private Long securityLevelId;
    private String priorityId;
    private String resolutionId;
    private String statusId;
    private Long votes;
    private Long watches;
    private Long originalEstimate;
    private Long estimate;
    private Long timespent;
    private Long workflowId;
    private Set<Label> labels;
    private GenericValue project;
    private GenericValue issueType;
    private User assignee;
    private User reporter;
    private Collection<GenericValue> components;
    private Collection<Version> affectedVersions;
    private Collection<Version> fixVersions;
    private GenericValue securityLevel;
    private GenericValue priority;
    private GenericValue resolution;
    private GenericValue status;
    private final Map<CustomField, Object> customFieldValues;
    private final Map<String, ModifiedValue> modifiedFields;
    private final Map<String, Object> externalFields;
    private Long parentId;
    boolean hasNoParentId = false;
    private Issue parentIssue;

    public IssueImpl(GenericValue genericValue, IssueManager issueManager, ProjectManager projectManager, VersionManager versionManager, IssueSecurityLevelManager issueSecurityLevelManager, ConstantsManager constantsManager, SubTaskManager subTaskManager, AttachmentManager attachmentManager, LabelManager labelManager, ProjectComponentManager projectComponentManager, UserManager userManager) {
        super(constantsManager, issueManager, attachmentManager);
        this.genericValue = genericValue;
        this.projectManager = projectManager;
        this.versionManager = versionManager;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.subTaskManager = subTaskManager;
        this.labelManager = labelManager;
        this.projectComponentManager = projectComponentManager;
        this.userManager = userManager;
        this.customFieldValues = new HashMap<CustomField, Object>();
        this.modifiedFields = new HashMap<String, ModifiedValue>();
        this.externalFields = new HashMap<String, Object>();
        this.init(genericValue);
    }

    public IssueImpl(Issue issue, IssueManager issueManager, ProjectManager projectManager, VersionManager versionManager, IssueSecurityLevelManager issueSecurityLevelManager, ConstantsManager constantsManager, SubTaskManager subTaskManager, AttachmentManager attachmentManager, LabelManager labelManager, ProjectComponentManager projectComponentManager, UserManager userManager) {
        this((GenericValue)null, issueManager, projectManager, versionManager, issueSecurityLevelManager, constantsManager, subTaskManager, attachmentManager, labelManager, projectComponentManager, userManager);
        this.setAffectedVersions(issue.getAffectedVersions());
        this.setFixVersions(issue.getFixVersions());
        this.setComponents(issue.getComponents());
        this.setLabels(issue.getLabels());
        this.init(issue.getGenericValue());
        this.setParentId(issue.getParentId());
    }

    public static MutableIssue getIssueObject(GenericValue genericValue) {
        return new IssueImpl(genericValue, ComponentAccessor.getIssueManager(), ComponentAccessor.getProjectManager(), ComponentAccessor.getVersionManager(), ManagerFactory.getIssueSecurityLevelManager(), ComponentAccessor.getConstantsManager(), ComponentManager.getInstance().getSubTaskManager(), ComponentAccessor.getAttachmentManager(), ComponentManager.getComponentInstanceOfType(LabelManager.class), ComponentManager.getComponentInstanceOfType(ProjectComponentManager.class), ComponentManager.getComponentInstanceOfType(UserManager.class));
    }

    private void init(GenericValue genericValue) {
        if (genericValue != null) {
            this.projectId = genericValue.getLong("project");
            this.key = genericValue.getString("key");
            this.issueTypeId = genericValue.getString("type");
            this.summary = genericValue.getString("summary");
            this.description = genericValue.getString("description");
            this.environment = genericValue.getString("environment");
            this.assigneeId = genericValue.getString("assignee");
            this.reporterId = genericValue.getString("reporter");
            this.dueDate = genericValue.getTimestamp("duedate");
            this.securityLevelId = genericValue.getLong("security");
            this.priorityId = genericValue.getString("priority");
            this.statusId = genericValue.getString("status");
            this.resolutionId = genericValue.getString("resolution");
            this.created = genericValue.getTimestamp("created");
            this.updated = genericValue.getTimestamp("updated");
            this.resolutionDate = genericValue.getTimestamp("resolutiondate");
            this.originalEstimate = genericValue.getLong("timeoriginalestimate");
            this.estimate = genericValue.getLong("timeestimate");
            this.timespent = genericValue.getLong("timespent");
            this.votes = genericValue.getLong("votes");
            this.watches = genericValue.getLong("watches");
            if (this.votes == null) {
                this.votes = new Long(0L);
            }
            this.workflowId = genericValue.getLong("workflowId");
        }
    }

    @Override
    public Long getId() {
        return this.genericValue == null ? null : this.genericValue.getLong("id");
    }

    @Override
    public GenericValue getProject() {
        if (this.project == null && this.projectId != null) {
            this.project = this.projectManager.getProject(this.projectId);
        }
        return this.project;
    }

    @Override
    public Project getProjectObject() {
        Project project = null;
        if (this.projectId != null) {
            project = this.projectManager.getProjectObj(this.projectId);
        }
        return project;
    }

    @Override
    public void setProjectId(Long projectId) {
        if (projectId == null) {
            this.setProject(null);
        } else {
            GenericValue gvProject = this.projectManager.getProject(projectId);
            if (gvProject == null) {
                throw new IllegalArgumentException("Invalid Project ID '" + projectId + "'.");
            }
            this.setProject(gvProject);
        }
    }

    @Override
    public void setProject(GenericValue project) {
        ModifiedValue modifiedValue = new ModifiedValue(this.getProject(), project);
        this.project = project;
        this.modifiedFields.put("project", modifiedValue);
        this.projectId = project != null ? project.getLong("id") : null;
        if (this.genericValue != null) {
            this.genericValue.set("project", (Object)this.projectId);
        }
    }

    @Override
    public void setProjectObject(Project project) {
        if (project == null) {
            this.setProject(null);
        } else {
            this.setProject(project.getGenericValue());
        }
    }

    @Override
    public GenericValue getIssueType() {
        if (this.issueType == null && this.issueTypeId != null) {
            this.issueType = this.constantsManager.getIssueType(this.issueTypeId);
        }
        return this.issueType;
    }

    @Override
    public void setIssueType(GenericValue issueType) {
        ModifiedValue modifiedValue = new ModifiedValue(this.getIssueType(), issueType);
        this.issueType = issueType;
        this.modifiedFields.put("issuetype", modifiedValue);
        this.issueTypeId = issueType != null ? issueType.getString("id") : null;
        this.updateGV("type", this.issueTypeId);
    }

    @Override
    public void setIssueTypeObject(IssueType issueType) {
        if (issueType == null) {
            this.setIssueType(null);
        } else {
            this.setIssueType(issueType.getGenericValue());
        }
    }

    @Override
    public void setIssueTypeId(String issueTypeId) {
        if (issueTypeId != null) {
            this.setIssueType(this.constantsManager.getIssueType(issueTypeId));
        } else {
            this.setIssueType(null);
        }
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public void setSummary(String summary) {
        ModifiedValue modifiedValue = new ModifiedValue(this.getSummary(), summary);
        this.summary = summary;
        this.updateGV("summary", summary);
        this.modifiedFields.put("summary", modifiedValue);
    }

    @Override
    public User getReporterUser() {
        return this.getReporter();
    }

    @Override
    public User getReporter() {
        if (this.reporter == null && this.reporterId != null) {
            this.reporter = this.getUser(this.reporterId);
        }
        return this.reporter;
    }

    @Override
    public String getReporterId() {
        return this.reporterId;
    }

    @Override
    public void setReporter(User reporter) {
        ModifiedValue modifiedValue = new ModifiedValue(this.getReporter(), reporter);
        this.reporter = reporter;
        this.modifiedFields.put("reporter", modifiedValue);
        this.reporterId = reporter != null ? reporter.getName() : null;
        this.updateGV("reporter", this.reporterId);
    }

    @Override
    public void setReporterId(String reporterId) {
        this.setReporter(this.getUser(reporterId));
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        ModifiedValue modifiedValue = new ModifiedValue(this.getDescription(), description);
        this.description = description;
        this.modifiedFields.put("description", modifiedValue);
        this.updateGV("description", description);
    }

    @Override
    public String getEnvironment() {
        return this.environment;
    }

    @Override
    public void setEnvironment(String environment) {
        ModifiedValue modifiedValue = new ModifiedValue(this.getEnvironment(), environment);
        this.environment = environment;
        this.modifiedFields.put("environment", modifiedValue);
        this.updateGV("environment", environment);
    }

    @Override
    public User getAssigneeUser() {
        return this.getAssignee();
    }

    @Override
    public User getAssignee() {
        if (this.assignee == null && this.assigneeId != null) {
            this.assignee = this.getUser(this.assigneeId);
        }
        return this.assignee;
    }

    @Override
    public String getAssigneeId() {
        return this.assigneeId;
    }

    @Override
    public void setAssignee(User assignee) {
        ModifiedValue modifiedValue = new ModifiedValue(this.getAssignee(), assignee);
        this.assignee = assignee;
        this.modifiedFields.put("assignee", modifiedValue);
        this.assigneeId = assignee != null ? assignee.getName() : null;
        this.updateGV("assignee", this.assigneeId);
    }

    @Override
    public void setAssigneeId(String assigneeName) {
        this.setAssignee(this.getUser(assigneeName));
    }

    @Override
    public Collection<ProjectComponent> getComponentObjects() {
        return this.projectComponentManager.findComponentsByIssue(this);
    }

    @Override
    public Collection<GenericValue> getComponents() {
        if (this.components == null) {
            this.components = this.projectComponentManager.findComponentsByIssueGV(this);
        }
        return new ArrayList<GenericValue>(this.components);
    }

    @Override
    public void setComponents(Collection<GenericValue> components) {
        ModifiedValue modifiedValue = new ModifiedValue(this.getComponents(), components);
        this.components = components;
        this.modifiedFields.put("components", modifiedValue);
    }

    @Override
    public void setComponentObjects(Collection<ProjectComponent> components) {
        if (components == null) {
            components = Collections.emptyList();
        }
        ArrayList<GenericValue> gvComponents = new ArrayList<GenericValue>(components.size());
        for (ProjectComponent component : components) {
            gvComponents.add(component.getGenericValue());
        }
        this.setComponents(gvComponents);
    }

    @Override
    public Collection<Version> getFixVersions() {
        if (this.fixVersions == null) {
            if (this.genericValue != null) {
                ArrayList<Version> newValue = new ArrayList<Version>(this.versionManager.getFixVersionsFor(this));
                Collections.sort(newValue, VersionComparator.COMPARATOR);
                this.fixVersions = newValue;
            } else {
                this.fixVersions = Collections.emptyList();
            }
        }
        return new ArrayList<Version>(this.fixVersions);
    }

    @Override
    public void setFixVersions(Collection<Version> fixVersions) {
        ModifiedValue modifiedValue = new ModifiedValue(this.getFixVersions(), fixVersions);
        this.fixVersions = fixVersions;
        this.modifiedFields.put("fixVersions", modifiedValue);
    }

    @Override
    public Timestamp getDueDate() {
        return this.dueDate;
    }

    @Override
    public void setDueDate(Timestamp dueDate) {
        ModifiedValue modifiedValue = new ModifiedValue(this.getDueDate(), dueDate);
        this.dueDate = dueDate;
        this.modifiedFields.put("duedate", modifiedValue);
        this.updateGV("duedate", dueDate);
    }

    @Override
    public GenericValue getSecurityLevel() {
        if (this.securityLevel == null && this.securityLevelId != null) {
            try {
                this.securityLevel = this.issueSecurityLevelManager.getIssueSecurityLevel(this.securityLevelId);
            }
            catch (GenericEntityException e) {
                throw new DataAccessException("Cannot retrieve security level with id '" + this.securityLevelId + "'.", e);
            }
        }
        return this.securityLevel;
    }

    @Override
    public Long getSecurityLevelId() {
        return this.securityLevelId;
    }

    @Override
    public void setSecurityLevelId(Long securityLevelId) {
        if (securityLevelId == null) {
            this.setSecurityLevel(null);
        } else {
            GenericValue securityLevelGV = null;
            try {
                securityLevelGV = this.issueSecurityLevelManager.getIssueSecurityLevel(securityLevelId);
            }
            catch (GenericEntityException e) {
                throw new IllegalArgumentException("Invalid SecurityLevel ID '" + securityLevelId + "'.");
            }
            if (securityLevelGV == null) {
                throw new IllegalArgumentException("Invalid SecurityLevel ID '" + securityLevelId + "'.");
            }
            this.setSecurityLevel(securityLevelGV);
        }
    }

    @Override
    public void setSecurityLevel(GenericValue securityLevel) {
        ModifiedValue modifiedValue = new ModifiedValue(this.getSecurityLevel(), securityLevel);
        this.securityLevel = securityLevel;
        this.modifiedFields.put("security", modifiedValue);
        this.securityLevelId = securityLevel != null ? securityLevel.getLong("id") : null;
        this.updateGV("security", this.securityLevelId);
    }

    @Override
    public GenericValue getPriority() {
        if (this.priority == null && this.priorityId != null) {
            Priority priorityObject = this.constantsManager.getPriorityObject(this.priorityId);
            this.priority = priorityObject != null ? priorityObject.getGenericValue() : null;
        }
        return this.priority;
    }

    @Override
    public void setPriority(GenericValue priority) {
        ModifiedValue modifiedValue = new ModifiedValue(this.getPriority(), priority);
        this.priority = priority;
        this.modifiedFields.put("priority", modifiedValue);
        this.priorityId = priority != null ? priority.getString("id") : null;
        this.updateGV("priority", this.priorityId);
    }

    @Override
    public void setPriorityObject(Priority priority) {
        if (priority == null) {
            this.setPriority(null);
        } else {
            this.setPriority(priority.getGenericValue());
        }
    }

    @Override
    public void setPriorityId(String priorityId) {
        if (priorityId != null) {
            Priority priorityObject = this.constantsManager.getPriorityObject(priorityId);
            this.setPriority(priorityObject != null ? priorityObject.getGenericValue() : null);
        } else {
            this.setPriority(null);
        }
    }

    @Override
    public String getResolutionId() {
        return this.resolutionId;
    }

    @Override
    public GenericValue getResolution() {
        if (this.resolution == null && this.resolutionId != null) {
            this.resolution = this.constantsManager.getResolution(this.resolutionId);
        }
        return this.resolution;
    }

    @Override
    public void setResolutionId(String resolutionId) {
        if (resolutionId != null) {
            this.setResolution(this.constantsManager.getResolution(resolutionId));
        } else {
            this.setResolution(null);
        }
    }

    @Override
    public void setResolution(GenericValue resolution) {
        ModifiedValue modifiedValue = new ModifiedValue(this.getResolution(), resolution);
        this.resolution = resolution;
        this.modifiedFields.put("resolution", modifiedValue);
        if (resolution != null && resolution.getString("id") != null) {
            String oldResolutionId = this.resolutionId;
            this.resolutionId = resolution.getString("id");
            if (!this.resolutionId.equals(oldResolutionId) || this.resolutionDate == null) {
                this.setResolutionDate(new Timestamp(System.currentTimeMillis()));
            }
        } else {
            this.resolutionId = null;
            this.setResolutionDate(null);
        }
        this.updateGV("resolution", this.resolutionId);
    }

    @Override
    public void setResolutionObject(Resolution resolution) {
        if (resolution == null) {
            this.setResolution(null);
        } else {
            this.setResolution(resolution.getGenericValue());
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
        this.updateGV("key", key);
    }

    @Override
    public Long getVotes() {
        return this.votes;
    }

    @Override
    public void setVotes(Long votes) {
        this.votes = votes;
        this.updateGV("votes", votes);
    }

    @Override
    public Long getWatches() {
        return this.watches;
    }

    @Override
    public void setWatches(Long watches) {
        this.watches = watches;
        this.updateGV("watches", watches);
    }

    @Override
    public Collection<Version> getAffectedVersions() {
        if (this.affectedVersions == null) {
            if (this.genericValue != null) {
                ArrayList<Version> newValue = new ArrayList<Version>(this.versionManager.getAffectedVersionsFor(this));
                Collections.sort(newValue, VersionComparator.COMPARATOR);
                this.affectedVersions = newValue;
            } else {
                this.affectedVersions = Collections.emptyList();
            }
        }
        return new ArrayList<Version>(this.affectedVersions);
    }

    @Override
    public void setAffectedVersions(Collection<Version> affectedVersions) {
        ModifiedValue modifiedValue = new ModifiedValue(this.getAffectedVersions(), affectedVersions);
        this.affectedVersions = affectedVersions;
        this.modifiedFields.put("versions", modifiedValue);
    }

    @Override
    public String getString(String name) {
        if (this.genericValue != null) {
            return this.genericValue.getString(name);
        }
        throw new IllegalStateException("Cannot retrieve '" + name + "' as the issue has not been saved yet.");
    }

    @Override
    public Timestamp getTimestamp(String name) {
        if (this.genericValue != null) {
            return this.genericValue.getTimestamp(name);
        }
        throw new IllegalArgumentException("Cannot retrieve '" + name + "' as the issue has not been saved yet.");
    }

    @Override
    public Long getLong(String name) {
        if (this.genericValue != null) {
            return this.genericValue.getLong(name);
        }
        throw new IllegalArgumentException("Cannot retrieve '" + name + "' as the issue has not been saved yet.");
    }

    @Override
    public GenericValue getGenericValue() {
        return this.genericValue;
    }

    @Override
    public Timestamp getCreated() {
        return this.created;
    }

    @Override
    public void setCreated(Timestamp created) {
        this.created = created;
        this.updateGV("created", created);
    }

    @Override
    public Timestamp getUpdated() {
        return this.updated;
    }

    @Override
    public void setUpdated(Timestamp updated) {
        this.updated = updated;
        this.updateGV("updated", updated);
    }

    @Override
    public Timestamp getResolutionDate() {
        return this.resolutionDate;
    }

    @Override
    public void setResolutionDate(Timestamp resolutionDate) {
        this.resolutionDate = resolutionDate;
        this.updateGV("resolutiondate", resolutionDate);
    }

    @Override
    public Long getWorkflowId() {
        return this.workflowId;
    }

    @Override
    public void setWorkflowId(Long workflowId) {
        this.workflowId = workflowId;
    }

    @Override
    public Object getCustomFieldValue(CustomField customField) {
        if (!this.customFieldValues.containsKey(customField)) {
            if (this.genericValue != null) {
                this.customFieldValues.put(customField, customField.getValue(this));
            } else {
                this.customFieldValues.put(customField, customField.getDefaultValue(this));
            }
        }
        return this.customFieldValues.get(customField);
    }

    @Override
    public void setCustomFieldValue(CustomField customField, Object value) {
        ModifiedValue modifiedValue = new ModifiedValue(this.getCustomFieldValue(customField), value);
        this.customFieldValues.put(customField, value);
        this.modifiedFields.put(customField.getId(), modifiedValue);
    }

    @Override
    public Object getExternalFieldValue(String fieldId) {
        return this.externalFields.get(fieldId);
    }

    @Override
    public void setExternalFieldValue(String fieldId, Object newValue) {
        this.setExternalFieldValue(fieldId, null, newValue);
    }

    @Override
    public void setExternalFieldValue(String fieldId, Object oldValue, Object newValue) {
        ModifiedValue modifiedValue = new ModifiedValue(oldValue, newValue);
        this.externalFields.put(fieldId, newValue);
        this.modifiedFields.put(fieldId, modifiedValue);
    }

    @Override
    public boolean isSubTask() {
        return this.getParentId() != null;
    }

    @Override
    public Long getParentId() {
        if (this.parentId == null && this.getGenericValue() != null && !this.hasNoParentId) {
            this.parentId = this.subTaskManager.getParentIssueId(this.getGenericValue());
            if (this.parentId == null) {
                this.hasNoParentId = true;
            }
        }
        return this.parentId;
    }

    @Override
    public void setParentId(Long parentId) {
        this.parentId = parentId;
        this.parentIssue = null;
    }

    @Override
    public void setParentObject(Issue parentIssue) throws IllegalArgumentException {
        if (parentIssue == null) {
            this.parentId = null;
        } else {
            if (parentIssue.getId() == null) {
                throw new IllegalArgumentException("Parent issue cannot have a null ID.");
            }
            this.parentId = parentIssue.getId();
        }
        this.parentIssue = parentIssue;
    }

    @Override
    public Issue getParentObject() {
        if (this.parentIssue == null) {
            return super.getParentObject();
        }
        return this.parentIssue;
    }

    @Override
    public GenericValue getParent() {
        if (this.parentIssue == null) {
            return super.getParent();
        }
        return this.parentIssue.getGenericValue();
    }

    @Override
    public Collection<GenericValue> getSubTasks() {
        if (this.isCreated()) {
            return this.subTaskManager.getSubTasks(this.getGenericValue());
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<Issue> getSubTaskObjects() {
        if (this.isCreated()) {
            return this.subTaskManager.getSubTaskObjects(this);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isCreated() {
        return this.getGenericValue() != null;
    }

    @Override
    public GenericValue getStatus() {
        if (this.status == null && this.statusId != null) {
            this.status = this.constantsManager.getStatus(this.statusId);
        }
        return this.status;
    }

    @Override
    public void setStatusId(String statusId) {
        this.statusId = statusId;
        this.status = this.constantsManager.getStatus(statusId);
        this.updateGV("status", statusId);
    }

    @Override
    public void setLabels(Set<Label> labels) {
        String oldLabels = StringUtils.join(this.getLabels(), (String)" ");
        String newLabels = StringUtils.join(labels, (String)" ");
        ModifiedValue modifiedValue = new ModifiedValue(oldLabels, newLabels);
        this.labels = labels;
        this.modifiedFields.put("labels", modifiedValue);
    }

    @Override
    public Set<Label> getLabels() {
        if (this.labels == null) {
            this.labels = this.genericValue != null ? this.labelManager.getLabels(this.getId()) : Collections.emptySet();
        }
        return this.labels;
    }

    @Override
    public void setStatus(GenericValue status) {
        this.status = status;
        if (status != null) {
            this.statusId = status.getString("id");
        }
        this.updateGV("status", this.statusId);
    }

    @Override
    public void setStatusObject(Status status) {
        if (status == null) {
            this.setStatus(null);
        } else {
            this.setStatus(status.getGenericValue());
        }
    }

    @Override
    public Long getOriginalEstimate() {
        return this.originalEstimate;
    }

    @Override
    public void setOriginalEstimate(Long originalEstimate) {
        ModifiedValue modifiedValue = new ModifiedValue(this.getOriginalEstimate(), originalEstimate);
        this.originalEstimate = originalEstimate;
        this.modifiedFields.put("timetracking", modifiedValue);
        this.updateGV("timeoriginalestimate", originalEstimate);
    }

    @Override
    public Long getEstimate() {
        return this.estimate;
    }

    @Override
    public void setEstimate(Long estimate) {
        ModifiedValue modifiedValue = new ModifiedValue(this.getEstimate(), estimate);
        this.estimate = estimate;
        this.modifiedFields.put("timetracking", modifiedValue);
        this.updateGV("timeestimate", estimate);
    }

    @Override
    public Long getTimeSpent() {
        return this.timespent;
    }

    @Override
    public void setTimeSpent(Long timespent) {
        this.timespent = timespent;
        this.updateGV("timespent", timespent);
    }

    @Override
    public IssueRenderContext getIssueRenderContext() {
        return new IssueRenderContext(this);
    }

    @Override
    public void store() {
        try {
            if (!this.isCreated()) {
                FieldMap fields = new FieldMap();
                fields.put("project", this.projectId);
                fields.put("type", this.issueTypeId);
                fields.put("created", this.created);
                fields.put("updated", this.updated);
                fields.put("duedate", this.dueDate);
                fields.put("resolutiondate", this.resolutionDate);
                fields.put("assignee", this.assigneeId);
                fields.put("reporter", this.reporterId);
                fields.put("summary", this.summary);
                fields.put("description", this.description);
                fields.put("environment", this.environment);
                fields.put("priority", this.priorityId);
                fields.put("status", this.statusId);
                fields.put("key", this.key);
                fields.put("votes", this.votes);
                fields.put("watches", this.watches);
                fields.put("security", this.securityLevelId);
                fields.put("timeoriginalestimate", this.originalEstimate);
                fields.put("timeestimate", this.estimate);
                fields.put("timespent", this.timespent);
                fields.put("workflowId", this.workflowId);
                this.genericValue = EntityUtils.createValue("Issue", fields);
                this.init(this.genericValue);
            } else {
                this.genericValue.store();
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error occurred while storing issue.", e);
        }
    }

    @Override
    public Map<String, ModifiedValue> getModifiedFields() {
        return this.modifiedFields;
    }

    @Override
    public void resetModifiedFields() {
        this.modifiedFields.clear();
        this.externalFields.clear();
    }

    private void updateGV(String fieldName, Object fieldValue) {
        if (this.genericValue != null) {
            this.genericValue.set(fieldName, fieldValue);
        }
    }

    private User getUser(String username) {
        if (username != null) {
            return this.userManager.getUserEvenWhenUnknown(username);
        }
        return null;
    }

    public String toString() {
        return this.key == null ? this.summary : this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Issue)) {
            return false;
        }
        Issue issue = (Issue)o;
        return !(this.key == null ? issue.getKey() != null : !this.key.equals(issue.getKey()));
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }
}

