/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.ofbiz.AbstractOfBizValueWrapper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.LocaleParser;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.ofbiz.core.entity.GenericEntity;
import org.ofbiz.core.entity.GenericValue;

public class IssueConstantImpl
extends AbstractOfBizValueWrapper
implements IssueConstant {
    private final TranslationManager translationManager;
    private final JiraAuthenticationContext authenticationContext;
    private PropertySet ps;
    private final Object propertySetLock = new Object();
    private final Map<String, String> nameTranslations = new MapMaker().concurrencyLevel(1).makeComputingMap((Function)new IssueConstantTranslationFunction(true));
    private final Map<String, String> descriptionTranslations = new MapMaker().concurrencyLevel(1).makeComputingMap((Function)new IssueConstantTranslationFunction(false));

    public IssueConstantImpl(GenericValue genericValue, TranslationManager translationManager, JiraAuthenticationContext authenticationContext) {
        super(genericValue);
        this.translationManager = translationManager;
        this.authenticationContext = authenticationContext;
    }

    @Override
    public final String getId() {
        return this.genericValue.getString("id");
    }

    @Override
    public final String getName() {
        return this.genericValue.getString("name");
    }

    @Override
    public final void setName(String name) {
        this.genericValue.setString("name", name);
    }

    @Override
    public final String getDescription() {
        return this.genericValue.getString("description");
    }

    @Override
    public final void setDescription(String description) {
        this.genericValue.setString("description", description);
    }

    @Override
    public final Long getSequence() {
        return this.genericValue.getLong("sequence");
    }

    @Override
    public final void setSequence(Long sequence) {
        this.genericValue.set("sequence", (Object)sequence);
    }

    @Override
    public String getIconUrl() {
        return this.genericValue.getString("iconurl");
    }

    @Override
    public String getIconUrlHtml() {
        return StringEscapeUtils.escapeHtml((String)this.getIconUrl());
    }

    @Override
    public void setIconUrl(String iconURL) {
        this.genericValue.setString("iconurl", iconURL);
    }

    @Override
    public final String getNameTranslation() {
        return this.nameTranslations.get(this.authenticationContext.getLocale().toString());
    }

    @Override
    public final String getDescTranslation() {
        return this.descriptionTranslations.get(this.authenticationContext.getLocale().toString());
    }

    @Override
    public final String getNameTranslation(String locale) {
        return this.nameTranslations.get(locale);
    }

    @Override
    public final String getDescTranslation(String locale) {
        return this.descriptionTranslations.get(locale);
    }

    @Override
    public final String getNameTranslation(I18nHelper i18n) {
        return this.translationManager.getIssueConstantTranslation(this, true, i18n.getLocale().toString(), i18n);
    }

    @Override
    public final String getDescTranslation(I18nHelper i18n) {
        return this.translationManager.getIssueConstantTranslation(this, false, i18n.getLocale().toString(), i18n);
    }

    @Override
    public final void setTranslation(String translatedName, String translatedDesc, String issueConstantPrefix, Locale locale) {
        this.translationManager.setIssueConstantTranslation(this, issueConstantPrefix, locale, translatedName, translatedDesc);
        this.nameTranslations.remove(locale.toString());
        this.descriptionTranslations.remove(locale.toString());
    }

    @Override
    public final void deleteTranslation(String issueConstantPrefix, Locale locale) {
        this.translationManager.deleteIssueConstantTranslation(this, issueConstantPrefix, locale);
        this.nameTranslations.remove(locale.toString());
        this.descriptionTranslations.remove(locale.toString());
    }

    public final int compareTo(Object o) {
        return this.genericValue.compareTo((GenericEntity)((IssueConstant)o).getGenericValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PropertySet getPropertySet() {
        Object object = this.propertySetLock;
        synchronized (object) {
            if (this.ps == null) {
                String id = this.genericValue.getString("id");
                this.genericValue.set("id", (Object)new Long(id));
                PropertySet ofbizPs = OFBizPropertyUtils.getPropertySet(this.genericValue);
                this.genericValue.set("id", (Object)id);
                HashMap<String, Object> args = new HashMap<String, Object>();
                args.put("PropertySet", ofbizPs);
                args.put("bulkload", Boolean.TRUE);
                this.ps = PropertySetManager.getInstance((String)"cached", args);
            }
        }
        return this.ps;
    }

    private class IssueConstantTranslationFunction
    implements Function<String, String> {
        private final boolean isName;

        private IssueConstantTranslationFunction(boolean isName) {
            this.isName = isName;
        }

        public String apply(String key) {
            String translation = null;
            Locale locale = LocaleParser.parseLocale(key);
            if (locale != null) {
                translation = IssueConstantImpl.this.translationManager.getIssueConstantTranslation((IssueConstant)IssueConstantImpl.this, this.isName, locale);
            }
            return translation == null ? "" : translation;
        }
    }
}

