/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.status.Status;
import java.util.Collection;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractIssue
implements Issue {
    protected final ConstantsManager constantsManager;
    protected final IssueManager issueManager;
    protected final AttachmentManager attachmentManager;
    private Collection<Attachment> attachments;

    protected AbstractIssue(ConstantsManager constantsManager, IssueManager issueManager, AttachmentManager attachmentManager) {
        this.constantsManager = constantsManager;
        this.issueManager = issueManager;
        this.attachmentManager = attachmentManager;
    }

    @Override
    public IssueType getIssueTypeObject() {
        GenericValue issueType = this.getIssueType();
        if (issueType != null) {
            return this.constantsManager.getIssueTypeObject(issueType.getString("id"));
        }
        return null;
    }

    @Override
    public Priority getPriorityObject() {
        if (this.getPriority() != null) {
            return this.constantsManager.getPriorityObject(this.getPriority().getString("id"));
        }
        return null;
    }

    @Override
    public Resolution getResolutionObject() {
        if (this.getResolution() != null) {
            return this.constantsManager.getResolutionObject(this.getResolution().getString("id"));
        }
        return null;
    }

    @Override
    public Status getStatusObject() {
        GenericValue statusGV = this.getStatus();
        if (statusGV != null) {
            return this.constantsManager.getStatusObject(statusGV.getString("id"));
        }
        return null;
    }

    @Override
    public Issue getParentObject() {
        if (this.isSubTask()) {
            return this.issueManager.getIssueObject(this.getParentId());
        }
        return null;
    }

    @Override
    public GenericValue getParent() {
        if (this.isSubTask()) {
            return this.issueManager.getIssue(this.getParentId());
        }
        return null;
    }

    @Override
    public boolean isEditable() {
        if (this.getGenericValue() != null) {
            return this.issueManager.isEditable(this);
        }
        return true;
    }

    @Override
    public Collection<Attachment> getAttachments() {
        if (this.attachments == null) {
            this.attachments = this.attachmentManager.getAttachments(this);
        }
        return this.attachments;
    }
}

