/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.index.CloseableIndex;
import com.atlassian.jira.index.Configuration;
import com.atlassian.jira.index.DefaultIndex;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.RuntimeIOException;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;

class DefaultManager
implements Index.Manager {
    private final Configuration configuration;
    private final DefaultIndex.Engine actor;
    private final CloseableIndex index;

    DefaultManager(@NotNull Configuration configuration, @NotNull DefaultIndex.Engine actor, @NotNull CloseableIndex index) {
        this.configuration = Assertions.notNull("configuration", configuration);
        this.actor = Assertions.notNull("actor", actor);
        this.index = Assertions.notNull("index", index);
    }

    @Override
    public Index getIndex() {
        return this.index;
    }

    public int getNumDocs() {
        return this.getSearcher().getIndexReader().numDocs();
    }

    @Override
    public IndexSearcher getSearcher() {
        return this.actor.getSearcher();
    }

    @Override
    public void deleteIndexDirectory() {
        this.actor.clean();
    }

    @Override
    public void close() {
        this.index.close();
    }

    @Override
    public boolean isIndexCreated() {
        try {
            return IndexReader.indexExists((Directory)this.configuration.getDirectory());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }
}

