/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.config.util.IndexWriterConfiguration;
import com.atlassian.jira.index.Configuration;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.dbc.Assertions;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.store.Directory;

public class DefaultConfiguration
implements Configuration {
    private final Directory directory;
    private final Analyzer analyzer;
    private final IndexWriterConfiguration writerConfiguration;

    public DefaultConfiguration(@NotNull Directory directory, @NotNull Analyzer analyzer) {
        this(directory, analyzer, Default.writerConfiguration);
    }

    public DefaultConfiguration(@NotNull Directory directory, @NotNull Analyzer analyzer, @NotNull IndexWriterConfiguration writerConfiguration) {
        this.directory = Assertions.notNull("directory", directory);
        this.analyzer = Assertions.notNull("analyzer", analyzer);
        this.writerConfiguration = Assertions.notNull("writerConfiguration", writerConfiguration);
    }

    @Override
    public Directory getDirectory() {
        return this.directory;
    }

    @Override
    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    @Override
    public IndexWriterConfiguration.WriterSettings getWriterSettings(Index.UpdateMode mode) {
        return mode.getWriterSettings(this.writerConfiguration);
    }

    private static final class Default {
        private static final int maxFieldLength = 1000000;
        private static final IndexWriterConfiguration.WriterSettings interactiveWriterSettings = new IndexWriterConfiguration.WriterSettings(){

            @Override
            public int getMergeFactor() {
                return 4;
            }

            @Override
            public int getMaxMergeDocs() {
                return 5000;
            }

            @Override
            public int getMaxBufferedDocs() {
                return 300;
            }

            @Override
            public int getMaxFieldLength() {
                return 1000000;
            }
        };
        private static final IndexWriterConfiguration.WriterSettings batchWriterSettings = new IndexWriterConfiguration.WriterSettings(){

            @Override
            public int getMergeFactor() {
                return 50;
            }

            @Override
            public int getMaxMergeDocs() {
                return Integer.MAX_VALUE;
            }

            @Override
            public int getMaxBufferedDocs() {
                return 300;
            }

            @Override
            public int getMaxFieldLength() {
                return 1000000;
            }
        };
        private static final IndexWriterConfiguration writerConfiguration = new IndexWriterConfiguration(){

            @Override
            public IndexWriterConfiguration.WriterSettings getInteractiveSettings() {
                return interactiveWriterSettings;
            }

            @Override
            public IndexWriterConfiguration.WriterSettings getBatchSettings() {
                return batchWriterSettings;
            }
        };

        private Default() {
        }
    }
}

