/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.transformer;

import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldValue;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldValueImpl;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.transformer.CustomFieldValueTransformer;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import org.apache.log4j.Logger;

public class CustomFieldValueTransformerImpl
implements CustomFieldValueTransformer {
    private static final Logger log = Logger.getLogger(CustomFieldValueTransformerImpl.class);
    private final CustomFieldManager customFieldManager;

    public CustomFieldValueTransformerImpl(CustomFieldManager customFieldManager) {
        this.customFieldManager = customFieldManager;
    }

    @Override
    public ExternalCustomFieldValue transform(ProjectImportMapper projectImportMapper, ExternalCustomFieldValue externalCustomFieldValue, Long newProjectId) {
        if (projectImportMapper.getCustomFieldMapper().isIgnoredCustomField(externalCustomFieldValue.getCustomFieldId())) {
            return null;
        }
        String mappedCustomFieldId = projectImportMapper.getCustomFieldMapper().getMappedId(externalCustomFieldValue.getCustomFieldId());
        CustomField customField = this.customFieldManager.getCustomFieldObject(new Long(mappedCustomFieldId));
        String oldIssueTypeId = projectImportMapper.getCustomFieldMapper().getIssueTypeForIssue(externalCustomFieldValue.getIssueId());
        String newIssueTypeId = projectImportMapper.getIssueTypeMapper().getMappedId(oldIssueTypeId);
        String mappedIssueId = projectImportMapper.getIssueMapper().getMappedId(externalCustomFieldValue.getIssueId());
        if (mappedIssueId == null) {
            log.debug((Object)("Found a custom field value with old issue id '" + externalCustomFieldValue.getIssueId() + "' but there is no mapped issue id."));
            return null;
        }
        ExternalCustomFieldValueImpl transformedExternalCustomFieldValue = new ExternalCustomFieldValueImpl(null, mappedCustomFieldId, mappedIssueId);
        FieldConfig relevantConfig = customField.getRelevantConfig(new IssueContextImpl(newProjectId, newIssueTypeId));
        ProjectCustomFieldImporter.MappedCustomFieldValue importValue = ((ProjectImportableCustomField)((Object)customField.getCustomFieldType())).getProjectImporter().getMappedImportValue(projectImportMapper, externalCustomFieldValue, relevantConfig);
        if (importValue.getValue() == null) {
            log.debug((Object)("Ignoring custom field value with old id '" + externalCustomFieldValue.getId() + "' because the custom field transformer returned a null transformed value."));
            return null;
        }
        if (externalCustomFieldValue.getStringValue() != null) {
            transformedExternalCustomFieldValue.setStringValue(importValue.getValue());
        } else if (externalCustomFieldValue.getDateValue() != null) {
            transformedExternalCustomFieldValue.setDateValue(importValue.getValue());
        } else if (externalCustomFieldValue.getNumberValue() != null) {
            transformedExternalCustomFieldValue.setNumberValue(importValue.getValue());
        } else if (externalCustomFieldValue.getTextValue() != null) {
            transformedExternalCustomFieldValue.setTextValue(importValue.getValue());
        }
        transformedExternalCustomFieldValue.setParentKey(importValue.getParentKey());
        return transformedExternalCustomFieldValue;
    }
}

