/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.taskprogress;

import com.atlassian.jira.imports.project.taskprogress.TaskProgressProcessor;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.util.I18nHelper;

public class EntityTypeTaskProgressProcessor
implements TaskProgressProcessor {
    private final int numEntityTypes;
    private final TaskProgressSink taskProgressSink;
    private final I18nHelper i18n;

    public EntityTypeTaskProgressProcessor(int numEntityTypes, TaskProgressSink taskProgressSink, I18nHelper i18n) {
        this.numEntityTypes = numEntityTypes;
        this.taskProgressSink = taskProgressSink;
        this.i18n = i18n;
    }

    @Override
    public void processTaskProgress(String entityTypeName, int entityTypeCount, long entityCount, long currentEntityCount) {
        if (this.taskProgressSink == null) {
            return;
        }
        int percent = (entityTypeCount - 1) * 100 / this.numEntityTypes;
        this.taskProgressSink.makeProgress(percent, this.i18n.getText("admin.message.task.progress.processing", entityTypeName), currentEntityCount + "");
    }
}

