/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.parser;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalAttachment;
import com.atlassian.jira.imports.project.parser.AttachmentParser;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.jira.util.dbc.Null;
import java.io.File;
import java.sql.Timestamp;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AttachmentParserImpl
implements AttachmentParser {
    private static final String ID = "id";
    private static final String ISSUE = "issue";
    private static final String FILENAME = "filename";
    private static final String CREATED = "created";
    private static final String AUTHOR = "author";

    @Override
    public ExternalAttachment parse(Map<String, String> attributes) throws ParseException {
        Null.not("attributes", attributes);
        String id = attributes.get(ID);
        String issueId = attributes.get(ISSUE);
        String fileName = attributes.get(FILENAME);
        String created = attributes.get(CREATED);
        String author = attributes.get(AUTHOR);
        if (StringUtils.isEmpty((String)id)) {
            throw new ParseException("A file attachment must have an id specified.");
        }
        if (StringUtils.isEmpty((String)issueId)) {
            throw new ParseException("A file attachment with id '" + id + "' must have an issue id specified.");
        }
        if (fileName == null) {
            throw new ParseException("A file attachment with id '" + id + "' must have a file name specified.");
        }
        if (StringUtils.isEmpty((String)created)) {
            throw new ParseException("A file attachment with id '" + id + "' must have a create date specified.");
        }
        Timestamp createdDate = Timestamp.valueOf(created);
        return new ExternalAttachment(id, issueId, fileName, createdDate, author);
    }

    @Override
    public String getFileAttachmentUrl(ExternalAttachment attachment, String attachmentPath, String projectKey, String issueKey) {
        AttachmentUtils.AttachmentAdapter attachmentAdapter = new AttachmentUtils.AttachmentAdapter(Long.valueOf(attachment.getId()), attachment.getFileName());
        File issueAttachmentDir = AttachmentUtils.getAttachmentDirectory(attachmentPath, projectKey, issueKey);
        File attachmentFile = AttachmentUtils.getAttachmentFile(attachmentAdapter, issueAttachmentDir);
        return attachmentFile.getAbsolutePath();
    }
}

