/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.mapper;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.external.beans.ExternalCustomField;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldConfiguration;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldOption;
import com.atlassian.jira.imports.project.mapper.AutomaticDataMapper;
import com.atlassian.jira.imports.project.mapper.CustomFieldMapper;
import com.atlassian.jira.imports.project.mapper.CustomFieldOptionMapper;
import com.atlassian.jira.imports.project.mapper.IssueLinkTypeMapper;
import com.atlassian.jira.imports.project.mapper.IssueTypeMapper;
import com.atlassian.jira.imports.project.mapper.ProjectImportIdMapper;
import com.atlassian.jira.imports.project.mapper.SimpleProjectImportIdMapper;
import com.atlassian.jira.imports.project.mapper.StatusMapper;
import com.atlassian.jira.imports.project.util.IssueTypeImportHelper;
import com.atlassian.jira.imports.project.validation.CustomFieldMapperValidator;
import com.atlassian.jira.imports.project.validation.StatusMapperValidator;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.ProjectContext;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class AutomaticDataMapperImpl
implements AutomaticDataMapper {
    private static final Logger log = Logger.getLogger(AutomaticDataMapperImpl.class);
    private final ConstantsManager constantsManager;
    private final CustomFieldManager customFieldManager;
    private final CustomFieldMapperValidator customFieldMapperValidator;
    private final ProjectManager projectManager;
    private final IssueTypeImportHelper issueTypeImportHelper;
    private final StatusMapperValidator statusMapperValidator;
    private final ProjectRoleManager projectRoleManager;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final SubTaskManager subTaskManager;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;

    public AutomaticDataMapperImpl(ConstantsManager constantsManager, CustomFieldManager customFieldManager, CustomFieldMapperValidator customFieldMapperValidator, ProjectManager projectManager, IssueTypeImportHelper issueTypeImportHelper, StatusMapperValidator statusMapperValidator, ProjectRoleManager projectRoleManager, IssueLinkTypeManager issueLinkTypeManager, SubTaskManager subTaskManager, IssueSecurityLevelManager issueSecurityLevelManager, IssueSecuritySchemeManager issueSecuritySchemeManager) {
        this.constantsManager = constantsManager;
        this.customFieldManager = customFieldManager;
        this.customFieldMapperValidator = customFieldMapperValidator;
        this.projectManager = projectManager;
        this.issueTypeImportHelper = issueTypeImportHelper;
        this.statusMapperValidator = statusMapperValidator;
        this.projectRoleManager = projectRoleManager;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.subTaskManager = subTaskManager;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
    }

    @Override
    public void mapIssueTypes(BackupProject backupProject, IssueTypeMapper issueTypeMapper) {
        for (String oldId : issueTypeMapper.getRegisteredOldIds()) {
            IssueType newIssueType = this.issueTypeImportHelper.getIssueTypeForName(issueTypeMapper.getKey(oldId));
            if (newIssueType == null || !this.issueTypeImportHelper.isMappingValid(newIssueType, backupProject.getProject().getKey(), issueTypeMapper.isSubTask(oldId))) continue;
            issueTypeMapper.mapValue(oldId, newIssueType.getId());
        }
    }

    @Override
    public void mapIssueLinkTypes(IssueLinkTypeMapper issueLinkTypeMapper) {
        for (String oldId : issueLinkTypeMapper.getRegisteredOldIds()) {
            String issueLinkTypeName = issueLinkTypeMapper.getKey(oldId);
            IssueLinkType newIssueLinkType = this.getIssueLinkTypeByName(issueLinkTypeName);
            if (newIssueLinkType == null || !this.checkStyleIsValid(oldId, newIssueLinkType, issueLinkTypeMapper)) continue;
            issueLinkTypeMapper.mapValue(oldId, newIssueLinkType.getId().toString());
        }
    }

    private boolean checkStyleIsValid(String oldId, IssueLinkType issueLinkType, IssueLinkTypeMapper issueLinkTypeMapper) {
        String oldStyle = issueLinkTypeMapper.getStyle(oldId);
        String newStyle = issueLinkType.getStyle();
        if (oldStyle == null) {
            return newStyle == null;
        }
        if (oldStyle.equals("jira_subtask") && !this.subTaskManager.isSubTasksEnabled()) {
            return false;
        }
        return oldStyle.equals(newStyle);
    }

    private IssueLinkType getIssueLinkTypeByName(String linkTypeName) {
        Collection<IssueLinkType> linkTypes = this.issueLinkTypeManager.getIssueLinkTypesByName(linkTypeName);
        if (linkTypes.isEmpty()) {
            return null;
        }
        return linkTypes.iterator().next();
    }

    @Override
    public void mapPriorities(SimpleProjectImportIdMapper priorityMapper) {
        HashMap<String, String> nameToIdMap = new HashMap<String, String>();
        for (Priority priority : this.constantsManager.getPriorityObjects()) {
            nameToIdMap.put(priority.getName(), priority.getId());
        }
        this.autopopulateMapper(priorityMapper, nameToIdMap);
    }

    @Override
    public void mapResolutions(SimpleProjectImportIdMapper resolutionMapper) {
        HashMap<String, String> nameToIdMap = new HashMap<String, String>();
        for (Resolution resolution : this.constantsManager.getResolutionObjects()) {
            nameToIdMap.put(resolution.getName(), resolution.getId());
        }
        this.autopopulateMapper(resolutionMapper, nameToIdMap);
    }

    @Override
    public void mapStatuses(BackupProject backupProject, StatusMapper statusMapper, IssueTypeMapper issueTypeMapper) {
        for (String oldStatusId : statusMapper.getRegisteredOldIds()) {
            Status newStatus = this.constantsManager.getStatusByName(statusMapper.getKey(oldStatusId));
            if (newStatus == null || !this.statusMapperValidator.isStatusValid(oldStatusId, newStatus, statusMapper, issueTypeMapper, backupProject.getProject().getKey())) continue;
            statusMapper.mapValue(oldStatusId, newStatus.getId());
        }
    }

    @Override
    public void mapProjectRoles(SimpleProjectImportIdMapper projectRoleMapper) {
        for (String oldProjectRoleId : projectRoleMapper.getRegisteredOldIds()) {
            ProjectRole newProjectRole = this.projectRoleManager.getProjectRole(projectRoleMapper.getKey(oldProjectRoleId));
            if (newProjectRole == null) continue;
            projectRoleMapper.mapValue(oldProjectRoleId, newProjectRole.getId().toString());
        }
    }

    @Override
    public void mapIssueSecurityLevels(String projectKey, SimpleProjectImportIdMapper securityLevelMapper) {
        Long issueSecuritySchemeId = this.getIssueSecuritySchemeId(projectKey);
        if (issueSecuritySchemeId == null) {
            return;
        }
        List<GenericValue> securityLevelsInScheme = this.issueSecurityLevelManager.getSchemeIssueSecurityLevels(issueSecuritySchemeId);
        for (String oldSecurityLevelId : securityLevelMapper.getRegisteredOldIds()) {
            String name = securityLevelMapper.getKey(oldSecurityLevelId);
            if (name == null) continue;
            for (GenericValue genericValue : securityLevelsInScheme) {
                if (!name.equals(genericValue.getString("name"))) continue;
                securityLevelMapper.mapValue(oldSecurityLevelId, genericValue.getLong("id").toString());
            }
        }
    }

    @Override
    public void mapProjects(SimpleProjectImportIdMapper projectMapper) {
        HashMap<String, String> nameToIdMap = new HashMap<String, String>();
        for (GenericValue gvProject : this.projectManager.getProjects()) {
            nameToIdMap.put(gvProject.getString("key"), gvProject.getLong("id").toString());
        }
        this.autopopulateMapper(projectMapper, nameToIdMap);
    }

    @Override
    public void mapCustomFields(BackupProject backupProject, CustomFieldMapper customFieldMapper, IssueTypeMapper issueTypeMapper) {
        block0: for (ExternalCustomFieldConfiguration oldCustomFieldConfig : backupProject.getCustomFields()) {
            ExternalCustomField oldCustomField = oldCustomFieldConfig.getCustomField();
            String oldCustomFieldTypeKey = oldCustomField.getTypeKey();
            if (!this.customFieldMapperValidator.customFieldTypeIsImportable(oldCustomFieldTypeKey)) {
                customFieldMapper.ignoreCustomField(oldCustomField.getId());
                continue;
            }
            String oldCustomFieldId = oldCustomField.getId();
            Collection<CustomField> customFieldsWithName = this.customFieldManager.getCustomFieldObjectsByName(oldCustomField.getName());
            if (customFieldsWithName == null) continue;
            for (CustomField newCustomField : customFieldsWithName) {
                if (!oldCustomFieldTypeKey.equals(newCustomField.getCustomFieldType().getKey()) || !this.customFieldMapperValidator.customFieldIsValidForRequiredContexts(oldCustomFieldConfig, newCustomField, oldCustomFieldId, customFieldMapper, issueTypeMapper, backupProject.getProject().getKey())) continue;
                customFieldMapper.mapValue(oldCustomField.getId(), newCustomField.getIdAsLong().toString());
                continue block0;
            }
        }
        for (String oldId : customFieldMapper.getRequiredOldIds()) {
            if (customFieldMapper.getKey(oldId) != null) continue;
            log.warn((Object)("The backup data has a custom field value in use for custom field with id: '" + oldId + "' but the backup data contains no reference to this field. The data will be not be imported."));
            customFieldMapper.ignoreCustomField(oldId);
        }
    }

    @Override
    public void mapCustomFieldOptions(BackupProject backupProject, CustomFieldOptionMapper customFieldOptionMapper, CustomFieldMapper customFieldMapper, IssueTypeMapper issueTypeMapper) {
        for (ExternalCustomFieldConfiguration externalCustomFieldConfiguration : backupProject.getCustomFields()) {
            Options options;
            Collection oldParentOptions = customFieldOptionMapper.getParentOptions(externalCustomFieldConfiguration.getConfigurationSchemeId());
            if (oldParentOptions.isEmpty() || (options = this.getNewOptions(backupProject, customFieldMapper, issueTypeMapper, externalCustomFieldConfiguration)) == null) continue;
            this.mapOptions(options, customFieldOptionMapper, oldParentOptions);
        }
    }

    Options getNewOptions(BackupProject backupProject, CustomFieldMapper customFieldMapper, IssueTypeMapper issueTypeMapper, ExternalCustomFieldConfiguration externalCustomFieldConfiguration) {
        String newCustomFieldId = customFieldMapper.getMappedId(externalCustomFieldConfiguration.getCustomField().getId());
        if (newCustomFieldId == null) {
            return null;
        }
        CustomField newCustomField = this.customFieldManager.getCustomFieldObject(new Long(newCustomFieldId));
        Project newProject = this.projectManager.getProjectObjByKey(backupProject.getProject().getKey());
        Long newProjectId = newProject != null ? newProject.getId() : null;
        String oldIssueTypeId = this.getFirstUsedIssueType(externalCustomFieldConfiguration);
        String newIssueTypeId = issueTypeMapper.getMappedId(oldIssueTypeId);
        IssueContextImpl issueContext = new IssueContextImpl(newProjectId, newIssueTypeId);
        FieldConfig relevantConfig = newCustomField.getRelevantConfig(issueContext);
        return newCustomField.getOptions(null, relevantConfig, this.getProjectContext(newProjectId));
    }

    JiraContextNode getProjectContext(Long newProjectId) {
        return new ProjectContext(newProjectId);
    }

    void mapOptions(Options options, CustomFieldOptionMapper customFieldOptionMapper, Collection parentOptions) {
        for (ExternalCustomFieldOption oldParentOption : parentOptions) {
            Option newParentOption = options.getOptionForValue(oldParentOption.getValue(), null);
            if (newParentOption == null) continue;
            customFieldOptionMapper.mapValue(oldParentOption.getId(), newParentOption.getOptionId().toString());
            Collection childOptions = customFieldOptionMapper.getChildOptions(oldParentOption.getId());
            for (ExternalCustomFieldOption oldChildOption : childOptions) {
                Option newChildOption = options.getOptionForValue(oldChildOption.getValue(), newParentOption.getOptionId());
                if (newChildOption == null) continue;
                customFieldOptionMapper.mapValue(oldChildOption.getId(), newChildOption.getOptionId().toString());
            }
        }
    }

    String getFirstUsedIssueType(ExternalCustomFieldConfiguration externalCustomFieldConfiguration) {
        if (externalCustomFieldConfiguration.getConstrainedIssueTypes() == null || externalCustomFieldConfiguration.getConstrainedIssueTypes().isEmpty()) {
            return null;
        }
        return (String)externalCustomFieldConfiguration.getConstrainedIssueTypes().iterator().next();
    }

    Long getIssueSecuritySchemeId(String projectKey) {
        GenericValue projectGV = this.projectManager.getProjectByKey(projectKey);
        if (projectGV == null) {
            return null;
        }
        try {
            List<GenericValue> schemes = this.issueSecuritySchemeManager.getSchemes(projectGV);
            if (schemes.isEmpty()) {
                return null;
            }
            GenericValue schemeGV = schemes.iterator().next();
            return schemeGV.getLong("id");
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
    }

    private void autopopulateMapper(ProjectImportIdMapper projectImportIdMapper, Map nameToIdMap) {
        for (String oldId : projectImportIdMapper.getRegisteredOldIds()) {
            String newId = (String)nameToIdMap.get(projectImportIdMapper.getKey(oldId));
            if (newId == null) continue;
            projectImportIdMapper.mapValue(oldId, newId);
        }
    }
}

