/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalLink;
import com.atlassian.jira.imports.project.ProjectImportPersister;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.handler.AbstractPersisterHandler;
import com.atlassian.jira.imports.project.handler.ImportEntityHandler;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.mapper.SimpleProjectImportIdMapper;
import com.atlassian.jira.imports.project.parser.IssueLinkParser;
import com.atlassian.jira.imports.project.parser.IssueLinkParserImpl;
import com.atlassian.jira.imports.project.transformer.IssueLinkTransformer;
import com.atlassian.jira.imports.project.transformer.IssueLinkTransformerImpl;
import com.atlassian.jira.issue.IssueManager;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.log4j.Logger;

public class IssueLinkPersisterHandler
extends AbstractPersisterHandler
implements ImportEntityHandler {
    private static final Logger log = Logger.getLogger(IssueLinkPersisterHandler.class);
    private final ProjectImportPersister projectImportPersister;
    private final ProjectImportMapper projectImportMapper;
    private final IssueManager issueManager;
    private final ProjectImportResults projectImportResults;
    private final BackupSystemInformation backupSystemInformation;
    private final User importAuthor;
    private IssueLinkTransformer issueLinkTransformer;
    private IssueLinkParser issueLinkParserImpl;

    public IssueLinkPersisterHandler(ProjectImportPersister projectImportPersister, ProjectImportMapper projectImportMapper, IssueManager issueManager, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor, User importAuthor) {
        super(executor, projectImportResults);
        this.projectImportPersister = projectImportPersister;
        this.projectImportMapper = projectImportMapper;
        this.issueManager = issueManager;
        this.projectImportResults = projectImportResults;
        this.backupSystemInformation = backupSystemInformation;
        this.importAuthor = importAuthor;
    }

    @Override
    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException, AbortImportException {
        if ("IssueLink".equals(entityName)) {
            final ExternalLink externalIssueLink = this.getIssueLinkParser().parse(attributes);
            if (externalIssueLink.getSourceId() == null || externalIssueLink.getDestinationId() == null) {
                log.warn((Object)("Ignoring Issue Link id='" + externalIssueLink.getId() + "'; the source or destination is missing."));
                return;
            }
            final ExternalLink transformedIssueLink = this.getIssueLinkTransformer().transform(this.projectImportMapper, externalIssueLink);
            if (transformedIssueLink != null) {
                this.execute(new Runnable(){

                    @Override
                    public void run() {
                        Long linkId = IssueLinkPersisterHandler.this.projectImportPersister.createEntity(IssueLinkPersisterHandler.this.getIssueLinkParser().getEntityRepresentation(transformedIssueLink));
                        if (linkId == null) {
                            String sourceKey = IssueLinkPersisterHandler.this.backupSystemInformation.getIssueKeyForId(externalIssueLink.getSourceId());
                            String destKey = IssueLinkPersisterHandler.this.backupSystemInformation.getIssueKeyForId(externalIssueLink.getDestinationId());
                            IssueLinkPersisterHandler.this.projectImportResults.addError(IssueLinkPersisterHandler.this.projectImportResults.getI18n().getText("admin.errors.project.import.issue.link.error", sourceKey, destKey));
                        } else {
                            boolean sourceOutsideProject = IssueLinkPersisterHandler.this.issueIsOutsideCurrentProject(externalIssueLink.getSourceId());
                            boolean destOutsideProject = IssueLinkPersisterHandler.this.issueIsOutsideCurrentProject(externalIssueLink.getDestinationId());
                            if (sourceOutsideProject || destOutsideProject) {
                                String issueId = sourceOutsideProject ? transformedIssueLink.getSourceId() : transformedIssueLink.getDestinationId();
                                SimpleProjectImportIdMapper issueMapper = IssueLinkPersisterHandler.this.projectImportMapper.getIssueMapper();
                                String inProjectIssueKey = sourceOutsideProject ? IssueLinkPersisterHandler.this.backupSystemInformation.getIssueKeyForId(externalIssueLink.getDestinationId()) : IssueLinkPersisterHandler.this.backupSystemInformation.getIssueKeyForId(externalIssueLink.getSourceId());
                                String issueKeyToReindex = IssueLinkPersisterHandler.this.projectImportPersister.createChangeItemForIssueLinkIfNeeded(issueId, transformedIssueLink.getLinkType(), inProjectIssueKey, sourceOutsideProject, IssueLinkPersisterHandler.this.importAuthor);
                                if (issueKeyToReindex != null) {
                                    issueMapper.mapValue(issueKeyToReindex, issueKeyToReindex);
                                }
                            }
                        }
                    }
                });
            }
        }
    }

    boolean issueIsOutsideCurrentProject(String issueId) {
        SimpleProjectImportIdMapper issueMapper = this.projectImportMapper.getIssueMapper();
        return issueMapper.getMappedId(issueId) == null;
    }

    IssueLinkTransformer getIssueLinkTransformer() {
        if (this.issueLinkTransformer == null) {
            this.issueLinkTransformer = new IssueLinkTransformerImpl(this.issueManager, this.backupSystemInformation);
        }
        return this.issueLinkTransformer;
    }

    IssueLinkParser getIssueLinkParser() {
        if (this.issueLinkParserImpl == null) {
            this.issueLinkParserImpl = new IssueLinkParserImpl();
        }
        return this.issueLinkParserImpl;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }
}

