/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.customfield;

import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldValue;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;

public class CascadingSelectCustomFieldImporter
implements ProjectCustomFieldImporter {
    @Override
    public MessageSet canMapImportValue(ProjectImportMapper projectImportMapper, ExternalCustomFieldValue customFieldValue, FieldConfig fieldConfig, I18nHelper i18n) {
        String optionId = customFieldValue.getValue();
        if (optionId != null) {
            projectImportMapper.getCustomFieldOptionMapper().flagValueAsRequired(optionId);
        }
        return null;
    }

    @Override
    public ProjectCustomFieldImporter.MappedCustomFieldValue getMappedImportValue(ProjectImportMapper projectImportMapper, ExternalCustomFieldValue customFieldValue, FieldConfig fieldConfig) {
        String oldOptionId = customFieldValue.getValue();
        String newOptionId = projectImportMapper.getCustomFieldOptionMapper().getMappedId(oldOptionId);
        String oldParentOptionId = customFieldValue.getParentKey();
        String newParentOptionId = projectImportMapper.getCustomFieldOptionMapper().getMappedId(oldParentOptionId);
        return new ProjectCustomFieldImporter.MappedCustomFieldValue(newOptionId, newParentOptionId);
    }
}

