/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.core;

import com.atlassian.jira.external.beans.ExternalComponent;
import com.atlassian.jira.external.beans.ExternalProject;
import com.atlassian.jira.external.beans.ExternalVersion;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldConfiguration;
import com.atlassian.jira.util.dbc.Null;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BackupProjectImpl
implements BackupProject {
    private final ExternalProject project;
    private final List<ExternalVersion> projectVersions;
    private final List<ExternalComponent> projectComponents;
    private final Set<Long> issueIds;
    private final Map<String, ExternalCustomFieldConfiguration> customFieldConfigurations;

    public BackupProjectImpl(ExternalProject project, List<ExternalVersion> versions, List<ExternalComponent> components, List<ExternalCustomFieldConfiguration> customFieldConfigurations, List<Long> issueIds) {
        Null.not("project", project);
        Null.not("versions", versions);
        Null.not("components", components);
        Null.not("customFieldConfigurations", customFieldConfigurations);
        Null.not("issueIds", issueIds);
        this.project = project;
        this.projectVersions = Collections.unmodifiableList(versions);
        this.projectComponents = Collections.unmodifiableList(components);
        this.customFieldConfigurations = new HashMap<String, ExternalCustomFieldConfiguration>();
        for (ExternalCustomFieldConfiguration configuration : customFieldConfigurations) {
            this.customFieldConfigurations.put(configuration.getCustomField().getId(), configuration);
        }
        this.issueIds = Collections.unmodifiableSet(new HashSet<Long>(issueIds));
    }

    @Override
    public ExternalProject getProject() {
        return this.project;
    }

    @Override
    public Collection<ExternalVersion> getProjectVersions() {
        return this.projectVersions;
    }

    @Override
    public Collection<ExternalComponent> getProjectComponents() {
        return this.projectComponents;
    }

    @Override
    public Collection<Long> getIssueIds() {
        return this.issueIds;
    }

    @Override
    public Collection<ExternalCustomFieldConfiguration> getCustomFields() {
        return Collections.unmodifiableCollection(this.customFieldConfigurations.values());
    }

    @Override
    public ExternalCustomFieldConfiguration getCustomFieldConfiguration(String customFieldId) {
        return this.customFieldConfigurations.get(customFieldId);
    }

    @Override
    public boolean containsIssue(String id) {
        if (id == null) {
            return false;
        }
        try {
            return this.getIssueIds().contains(new Long(id));
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("project: ").append(this.project.getKey());
        sb.append(" issueCount: ").append(this.issueIds.size());
        sb.append("\n");
        sb.append("versions: ");
        for (ExternalVersion externalVersion : this.projectVersions) {
            sb.append("\n");
            sb.append("     ");
            sb.append(externalVersion);
        }
        sb.append("\n");
        sb.append("comoponents: ");
        for (ExternalComponent externalComponent : this.projectComponents) {
            sb.append("\n");
            sb.append("     ");
            sb.append(externalComponent);
        }
        sb.append("\n");
        sb.append("customFieldConfigs: ");
        for (ExternalCustomFieldConfiguration externalCustomFieldConfiguration : this.customFieldConfigurations.values()) {
            sb.append("\n");
            sb.append("     ");
            sb.append(externalCustomFieldConfiguration);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackupProjectImpl that = (BackupProjectImpl)o;
        if (!((Object)this.customFieldConfigurations).equals(that.customFieldConfigurations)) {
            return false;
        }
        if (!((Object)this.issueIds).equals(that.issueIds)) {
            return false;
        }
        if (!this.project.equals(that.project)) {
            return false;
        }
        if (!((Object)this.projectComponents).equals(that.projectComponents)) {
            return false;
        }
        return ((Object)this.projectVersions).equals(that.projectVersions);
    }

    public int hashCode() {
        int result = this.project.hashCode();
        result = 31 * result + ((Object)this.projectVersions).hashCode();
        result = 31 * result + ((Object)this.projectComponents).hashCode();
        result = 31 * result + ((Object)this.issueIds).hashCode();
        result = 31 * result + ((Object)this.customFieldConfigurations).hashCode();
        return result;
    }
}

