/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.image.dropdown;

import com.atlassian.jira.image.dropdown.DropDownCreatorService;
import com.atlassian.jira.image.util.ImageUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class DefaultDropDownCreatorService
implements DropDownCreatorService {
    private static final Logger log = Logger.getLogger(DefaultDropDownCreatorService.class);
    private static final Color DEFAULT_COLOR = Color.BLACK;
    private static final Color DEFAULT_BG_COLOR = new Color(255, 255, 255, 0);
    private final ImageUtils imageUtils;

    public DefaultDropDownCreatorService(ImageUtils imageUtils) {
        this.imageUtils = imageUtils;
    }

    @Override
    public byte[] getDropdown(String colorHex, String backgroundColorHex) {
        BufferedImage image = new BufferedImage(7, 4, 2);
        Graphics2D graphics = image.createGraphics();
        Color backgroundColor = this.imageUtils.getColor(backgroundColorHex, false);
        graphics.setColor(backgroundColor == null ? DEFAULT_BG_COLOR : backgroundColor);
        graphics.fillRect(0, 0, 7, 4);
        Color color = this.imageUtils.getColor(colorHex, false);
        graphics.setColor(color == null ? DEFAULT_COLOR : color);
        graphics.drawLine(0, 0, 6, 0);
        graphics.drawLine(1, 1, 5, 1);
        graphics.drawLine(2, 2, 4, 2);
        graphics.drawLine(3, 3, 3, 3);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", byteArrayOutputStream);
        }
        catch (IOException e) {
            log.error((Object)"Wow!  An IOException occured with a ByteArrayOutputStream.  Is that even possible?", (Throwable)e);
            throw new RuntimeException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

