/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.favourites;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.favourites.FavouritesManager;
import com.atlassian.jira.favourites.FavouritesStore;
import com.atlassian.jira.sharing.ShareManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.SharedEntityAccessor;
import com.atlassian.jira.util.CollectionReorderer;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class DefaultFavouritesManager
implements FavouritesManager<SharedEntity> {
    private static final CollectionReorderer<SharedEntity> reorderer = new CollectionReorderer();
    private final FavouritesStore store;
    private final SharedEntityAccessor.Factory sharedEntityAccessorFactory;
    private final ShareManager shareManager;

    public DefaultFavouritesManager(FavouritesStore store, SharedEntityAccessor.Factory sharedEntityAccessorFactory, ShareManager shareManager) {
        this.store = store;
        this.sharedEntityAccessorFactory = sharedEntityAccessorFactory;
        this.shareManager = shareManager;
    }

    @Override
    public void addFavourite(User user, SharedEntity entity) throws PermissionException {
        this.validateInput(user, entity);
        this.checkPermissions(user, entity);
        if (this.store.addFavourite(user, entity)) {
            this.adjustFavouriteCount(entity, 1);
        }
    }

    @Override
    public void addFavouriteInPosition(User user, SharedEntity entity, long position) throws PermissionException {
        this.validateInput(user, entity);
        this.checkPermissions(user, entity);
        if (this.store.addFavourite(user, entity)) {
            this.adjustFavouriteCount(entity, 1);
            this.reorderFavourites(user, entity, new InsertInPositionReorderCommand((int)position));
        }
    }

    private void adjustFavouriteCount(SharedEntity entity, int incrementCount) {
        SharedEntityAccessor countAdjuster = this.sharedEntityAccessorFactory.getSharedEntityAccessor(entity.getEntityType());
        if (countAdjuster != null) {
            countAdjuster.adjustFavouriteCount(entity, incrementCount);
        }
    }

    @Override
    public void removeFavourite(User user, SharedEntity entity) {
        this.validateInput(user, entity);
        if (this.store.removeFavourite(user, entity)) {
            this.adjustFavouriteCount(entity, -1);
        }
    }

    @Override
    public boolean isFavourite(User user, SharedEntity entity) throws PermissionException {
        this.validateInput(user, entity);
        this.checkPermissions(user, entity);
        return this.store.isFavourite(user, entity);
    }

    @Override
    public Collection<Long> getFavouriteIds(User user, SharedEntity.TypeDescriptor<SharedEntity> entityType) {
        Assertions.notNull("user", user);
        Assertions.notNull("entity type", entityType);
        return this.store.getFavouriteIds(user, entityType);
    }

    @Override
    public void removeFavouritesForUser(User user, SharedEntity.TypeDescriptor<SharedEntity> entityType) {
        Assertions.notNull("user", user);
        Assertions.notNull("entity type", entityType);
        Collection<Long> ids = this.getFavouriteIds(user, entityType);
        for (Long id : ids) {
            this.removeFavourite(user, new SharedEntity.Identifier(id, entityType, user));
        }
    }

    @Override
    public void removeFavouritesForEntityDelete(SharedEntity entity) {
        Assertions.notNull("entity", entity);
        Assertions.notNull("entity type", entity.getEntityType());
        Assertions.notNull("entity Id", entity.getId());
        this.store.removeFavouritesForEntity(entity);
    }

    @Override
    public void increaseFavouriteSequence(User user, SharedEntity entity) throws PermissionException {
        this.reorderFavourites(user, entity, new FavouriteReordererCommand(){

            @Override
            public void reorderFavourites(List<SharedEntity> favouriteEntities, SharedEntity entity) {
                reorderer.increasePosition(favouriteEntities, entity);
            }
        });
    }

    @Override
    public void decreaseFavouriteSequence(User user, SharedEntity entity) throws PermissionException {
        this.reorderFavourites(user, entity, new FavouriteReordererCommand(){

            @Override
            public void reorderFavourites(List<SharedEntity> favouriteEntities, SharedEntity entity) {
                reorderer.decreasePosition(favouriteEntities, entity);
            }
        });
    }

    @Override
    public void moveToStartFavouriteSequence(User user, SharedEntity entity) throws PermissionException {
        this.reorderFavourites(user, entity, new FavouriteReordererCommand(){

            @Override
            public void reorderFavourites(List<SharedEntity> favouriteEntities, SharedEntity entity) {
                reorderer.moveToStart(favouriteEntities, entity);
            }
        });
    }

    @Override
    public void moveToEndFavouriteSequence(User user, SharedEntity entity) throws PermissionException {
        this.reorderFavourites(user, entity, new FavouriteReordererCommand(){

            @Override
            public void reorderFavourites(List<SharedEntity> favouriteEntities, SharedEntity entity) {
                reorderer.moveToEnd(favouriteEntities, entity);
            }
        });
    }

    void reorderFavourites(User user, SharedEntity entity, FavouriteReordererCommand favouriteReordererCommand) {
        this.validateInput(user, entity);
        Collection<Long> favIds = this.store.getFavouriteIds(user, entity.getEntityType());
        ArrayList dontHavePermission = new ArrayList();
        ArrayList<SharedEntity> favouriteEntities = new ArrayList<SharedEntity>();
        ArrayList<Long> deadFavourites = new ArrayList<Long>();
        SharedEntity targetEntity = null;
        SharedEntityAccessor sharedEntityAccessor = this.sharedEntityAccessorFactory.getSharedEntityAccessor(entity.getEntityType());
        for (Long favId : favIds) {
            Object favEntity = sharedEntityAccessor.getSharedEntity(favId);
            if (favEntity != null) {
                if (sharedEntityAccessor.hasPermissionToUse(user, favEntity)) {
                    favouriteEntities.add((SharedEntity)favEntity);
                    if (!favEntity.getId().equals(entity.getId())) continue;
                    targetEntity = (SharedEntity)favEntity;
                    continue;
                }
                dontHavePermission.add(favEntity);
                continue;
            }
            deadFavourites.add(favId);
        }
        if (targetEntity != null) {
            favouriteReordererCommand.reorderFavourites(favouriteEntities, targetEntity);
        }
        favouriteEntities.addAll(dontHavePermission);
        this.removeDeadFavourites(user, deadFavourites, entity.getEntityType());
        this.store.updateSequence(user, favouriteEntities);
    }

    private void removeDeadFavourites(User user, List<Long> deadFavourites, SharedEntity.TypeDescriptor<SharedEntity> entityType) {
        Iterator<Long> i$ = deadFavourites.iterator();
        while (i$.hasNext()) {
            Long element;
            Long favId = element = i$.next();
            SharedEntity.Identifier deadEntity = new SharedEntity.Identifier(favId, entityType, user);
            this.store.removeFavourite(user, deadEntity);
        }
    }

    private boolean hasUserPermissionToSeeEntity(User user, SharedEntity entity) {
        return this.shareManager.hasPermission(user, entity);
    }

    private void validateInput(User user, SharedEntity entity) {
        Assertions.notNull("user", user);
        Assertions.notNull("entity", entity);
        Assertions.notNull("entity type", entity.getEntityType());
        Assertions.notNull("entity Id", entity.getId());
    }

    private void checkPermissions(User user, SharedEntity entity) throws PermissionException {
        if (!this.hasUserPermissionToSeeEntity(user, entity)) {
            throw new PermissionException("User (" + user + ") does not have permission to see entity - " + entity.getEntityType() + ":" + entity.getId());
        }
    }

    static class InsertInPositionReorderCommand
    implements FavouriteReordererCommand {
        final int position;

        InsertInPositionReorderCommand(int position) {
            this.position = position;
        }

        @Override
        public void reorderFavourites(List<SharedEntity> favouriteEntities, SharedEntity entity) {
            reorderer.moveToPosition(favouriteEntities, favouriteEntities.size() - 1, this.position);
        }
    }

    static interface FavouriteReordererCommand {
        public void reorderFavourites(List<SharedEntity> var1, SharedEntity var2);
    }

    private static final class Count {
        private static final int INCREMENT = 1;
        private static final int DECREMENT = -1;

        private Count() {
        }
    }
}

