/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.type;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.EventTypeOrderTransformer;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.comparators.TransformingComparator;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultEventTypeManager
implements EventTypeManager,
Startable {
    private static final Logger log = Logger.getLogger(DefaultEventTypeManager.class);
    public static final String EVENT_TYPE_ID = "eventTypeId";
    private final OfBizDelegator delegator;
    private final WorkflowManager workflowManager;
    private final NotificationSchemeManager notificationSchemeManager;
    private final EventPublisher eventPublisher;
    private Collection eventTypes;
    private Map eventTypesMap;
    private final Comparator eventTypeComparator = new TransformingComparator((Transformer)new EventTypeOrderTransformer());

    public DefaultEventTypeManager(OfBizDelegator delegator, WorkflowManager workflowManager, NotificationSchemeManager notificationSchemeManager, EventPublisher eventPublisher) {
        this.delegator = delegator;
        this.workflowManager = workflowManager;
        this.notificationSchemeManager = notificationSchemeManager;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearCache();
    }

    @Override
    public Collection getEventTypes() {
        if (this.eventTypes == null) {
            this.eventTypes = this.getEventTypesMap().values();
        }
        return this.eventTypes;
    }

    @Override
    public synchronized Map getEventTypesMap() {
        if (this.eventTypesMap == null) {
            this.eventTypesMap = new ListOrderedMap();
            Collection allEventTypes = this.retrieveAllEntities();
            for (EventType eventType : allEventTypes) {
                this.eventTypesMap.put(eventType.getId(), eventType);
            }
        }
        return this.eventTypesMap;
    }

    @Override
    public EventType getEventType(Long id) {
        if (this.getEventTypesMap().containsKey(id)) {
            return (EventType)this.getEventTypesMap().get(id);
        }
        GenericValue issueEventTypeGV = this.retrieveEntityByPrimaryKey(EasyMap.build((Object)"id", (Object)id));
        if (issueEventTypeGV == null) {
            throw new IllegalArgumentException("No event type with id " + id);
        }
        return new EventType(issueEventTypeGV);
    }

    @Override
    public boolean isActive(EventType eventType) {
        return !this.getAssociatedWorkflows(eventType, true).isEmpty() || !this.getAssociatedNotificationSchemes(eventType).isEmpty();
    }

    @Override
    public MultiMap getAssociatedWorkflows(EventType eventType, boolean statusCheck) {
        MultiHashMap workflowTransitionMap = new MultiHashMap();
        Collection<JiraWorkflow> workflows = this.workflowManager.getWorkflows();
        Long eventTypeId = eventType.getId();
        for (JiraWorkflow workflow : workflows) {
            Map<ActionDescriptor, Collection<FunctionDescriptor>> transitionPostFunctionMap = this.workflowManager.getPostFunctionsForWorkflow(workflow);
            Set<ActionDescriptor> keys = transitionPostFunctionMap.keySet();
            for (ActionDescriptor actionDescriptor : keys) {
                Collection<FunctionDescriptor> postFunctions = transitionPostFunctionMap.get(actionDescriptor);
                for (FunctionDescriptor functionDescriptor : postFunctions) {
                    if (!functionDescriptor.getArgs().containsKey(EVENT_TYPE_ID) || !eventTypeId.equals(new Long((String)functionDescriptor.getArgs().get(EVENT_TYPE_ID)))) continue;
                    workflowTransitionMap.put((Object)workflow.getName(), (Object)actionDescriptor);
                    if (!statusCheck) continue;
                    return workflowTransitionMap;
                }
            }
        }
        return workflowTransitionMap;
    }

    @Override
    public Map getAssociatedNotificationSchemes(EventType eventType) {
        return this.notificationSchemeManager.getSchemesMapByConditions(EasyMap.build((Object)EVENT_TYPE_ID, (Object)eventType.getId()));
    }

    @Override
    public void addEventType(EventType eventType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", new Long(this.getNextEventTypeId()));
        params.put("name", eventType.getName());
        params.put("description", eventType.getDescription());
        params.put("templateId", eventType.getTemplateId());
        params.put("type", null);
        this.delegator.createValue("EventType", params);
        this.clearCache();
    }

    @Override
    public void editEventType(Long eventTypeId, String name, String description, Long templateId) {
        GenericValue eventTypeGV = this.retrieveEntityByPrimaryKey(EasyMap.build((Object)"id", (Object)eventTypeId));
        eventTypeGV.set("name", (Object)name);
        eventTypeGV.set("description", (Object)description);
        eventTypeGV.set("templateId", (Object)templateId);
        this.delegator.store(eventTypeGV);
        this.clearCache();
    }

    @Override
    public void deleteEventType(Long eventTypeId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("id", eventTypeId);
        this.delegator.removeByAnd("EventType", params);
        this.clearCache();
    }

    @Override
    public boolean isEventTypeExists(String issueEventTypeName) {
        if (issueEventTypeName == null) {
            throw new IllegalArgumentException("EventTypeName must not be null.");
        }
        for (EventType eventType : this.getEventTypes()) {
            if (!issueEventTypeName.equals(eventType.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEventTypeExists(Long eventTypeId) {
        if (eventTypeId == null) {
            throw new IllegalArgumentException("EventTypeId must not be null.");
        }
        Set keySet = this.getEventTypesMap().keySet();
        return keySet.contains(eventTypeId);
    }

    private Collection retrieveAllEntities() {
        ArrayList<EventType> eventTypes = new ArrayList<EventType>();
        List<GenericValue> eventTypeGVs = this.delegator.findAll("EventType");
        for (GenericValue eventTypeGV : eventTypeGVs) {
            EventType eventType = new EventType(eventTypeGV);
            eventTypes.add(eventType);
        }
        Collections.sort(eventTypes, this.eventTypeComparator);
        return eventTypes;
    }

    private GenericValue retrieveEntityByPrimaryKey(Map params) {
        return this.delegator.findByPrimaryKey("EventType", params);
    }

    private synchronized long getNextEventTypeId() {
        List entities;
        long startID = 10000L;
        try {
            entities = CoreFactory.getGenericDelegator().findAll("EventType");
        }
        catch (GenericEntityException e) {
            log.error((Object)"Error accessing database to retrieve event type IDs", (Throwable)e);
            throw new DataAccessException("Error accessing database to retrieve event type IDs", e);
        }
        for (GenericValue entity : entities) {
            long entityId = entity.getLong("id");
            if (entityId < startID) continue;
            startID = entityId + 1L;
        }
        return startID;
    }

    @Override
    public synchronized void clearCache() {
        this.eventTypes = null;
        this.eventTypesMap = null;
    }
}

