/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.listeners.search;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.AbstractIssueEventListener;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class IssueIndexListener
extends AbstractIssueEventListener {
    private static final Logger log = Logger.getLogger(IssueIndexListener.class);
    public static final String NAME = "Issue Index Listener";

    @Override
    public void init(Map params) {
    }

    @Override
    public String[] getAcceptedParams() {
        return new String[0];
    }

    @Override
    public boolean isInternal() {
        return true;
    }

    @Override
    public void issueCreated(IssueEvent event) {
        IssueIndexListener.reIndex(event);
    }

    @Override
    public void issueUpdated(IssueEvent event) {
        IssueIndexListener.reIndex(event);
    }

    @Override
    public void issueAssigned(IssueEvent event) {
        IssueIndexListener.reIndex(event);
    }

    @Override
    public void issueResolved(IssueEvent event) {
        IssueIndexListener.reIndex(event);
    }

    @Override
    public void issueClosed(IssueEvent event) {
        IssueIndexListener.reIndex(event);
    }

    @Override
    public void issueCommented(IssueEvent event) {
        IssueIndexListener.reIndex(event);
    }

    @Override
    public void issueWorkLogged(IssueEvent event) {
        IssueIndexListener.reIndex(event);
    }

    @Override
    public void issueReopened(IssueEvent event) {
        IssueIndexListener.reIndex(event);
    }

    @Override
    public void issueGenericEvent(IssueEvent event) {
        IssueIndexListener.reIndex(event);
    }

    @Override
    public void issueCommentEdited(IssueEvent event) {
        IssueIndexListener.reIndex(event);
    }

    @Override
    public void issueWorklogUpdated(IssueEvent event) {
        IssueIndexListener.reIndex(event);
    }

    @Override
    public void issueWorklogDeleted(IssueEvent event) {
        IssueIndexListener.reIndex(event);
    }

    @Override
    public void issueDeleted(IssueEvent event) {
    }

    @Override
    public void issueMoved(IssueEvent event) {
        IssueIndexListener.reIndex(event);
    }

    @Override
    public void customEvent(IssueEvent event) {
    }

    private static void reIndex(IssueEvent issueEvent) {
        HashSet<Issue> issuesToReindex = new HashSet<Issue>();
        Issue issue = issueEvent.getIssue();
        issuesToReindex.add(issue);
        if (issueEvent.isSubtasksUpdated()) {
            issuesToReindex.addAll(issue.getSubTaskObjects());
        }
        try {
            ComponentAccessor.getIssueIndexManager().reIndexIssueObjects(issuesToReindex);
        }
        catch (Throwable e) {
            log.error((Object)("Error re-indexing changes for issue '" + issue.getKey() + "'"), e);
        }
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getDescription() {
        return this.getI18NBean().getText("admin.listener.issue.index.desc");
    }
}

