/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.listeners;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.JiraEvent;
import com.atlassian.jira.event.issue.AbstractIssueEventListener;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.user.UserEvent;
import com.atlassian.jira.event.user.UserEventListener;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DebugListener
extends AbstractIssueEventListener
implements UserEventListener {
    @Override
    public void init(Map params) {
        this.log("DebugListener.init");
        this.log(params.toString());
    }

    @Override
    public String[] getAcceptedParams() {
        return new String[0];
    }

    @Override
    public void issueAssigned(IssueEvent event) {
        this.log("DebugListener.issueAssigned");
        this.logEvent(event);
    }

    @Override
    public void issueClosed(IssueEvent event) {
        this.log("DebugListener.issueClosed");
        this.logEvent(event);
    }

    @Override
    public void issueCreated(IssueEvent event) {
        this.log("DebugListener.issueCreated");
        this.logEvent(event);
    }

    @Override
    public void issueResolved(IssueEvent event) {
        this.log("DebugListener.issueResolved");
        this.logEvent(event);
    }

    @Override
    public void issueReopened(IssueEvent event) {
        this.log("DebugListener.issueReopened");
        this.logEvent(event);
    }

    @Override
    public void issueUpdated(IssueEvent event) {
        this.log("DebugListener.issueUpdated");
        try {
            List changeItems = event.getChangeLog().getRelated("ChildChangeItem");
            for (GenericValue changeItem : changeItems) {
                this.log("\t" + changeItem.get("field") + " changed from '" + changeItem.get("oldstring") + "' to '" + changeItem.get("newstring") + "'");
            }
        }
        catch (GenericEntityException e) {
            this.log("Error: " + (Object)((Object)e));
        }
        this.logEvent(event);
    }

    @Override
    public void issueCommented(IssueEvent event) {
        this.log("DebugListener.issueCommented");
        this.logEvent(event);
    }

    @Override
    public void issueDeleted(IssueEvent event) {
        this.log("DebugListener.issueCommented");
        this.logEvent(event);
    }

    @Override
    public void issueMoved(IssueEvent event) {
        this.log("DebugListener.issueMoved");
        this.logEvent(event);
    }

    @Override
    public void issueWorkLogged(IssueEvent event) {
        this.log("DebugListener.issueWorkLogged");
        this.logEvent(event);
    }

    @Override
    public void issueGenericEvent(IssueEvent event) {
        this.log("DebugListener.issueGenericEvent");
        this.logEvent(event);
    }

    @Override
    public void customEvent(IssueEvent event) {
        this.log("DebugListener.customEvent");
        this.logEvent(event);
    }

    @Override
    public void userSignup(UserEvent event) {
        this.log("DebugListener.userSignup");
        this.logEvent(event);
    }

    @Override
    public void userCreated(UserEvent event) {
        this.log("DebugListener.userCreated");
        this.logEvent(event);
    }

    @Override
    public void userForgotPassword(UserEvent event) {
        this.log("DebugListener.userForgotPassword");
        this.logEvent(event);
    }

    @Override
    public void userForgotUsername(UserEvent event) {
        this.log("DebugListener.userForgotUsername");
        this.logEvent(event);
    }

    @Override
    public void userCannotChangePassword(UserEvent event) {
        this.log("DebugListener.userCannotChangePassword");
        this.logEvent(event);
    }

    private void logEvent(JiraEvent event) {
        try {
            if (event instanceof IssueEvent) {
                IssueEvent issueEvent = (IssueEvent)event;
                this.log("Issue: [#" + issueEvent.getIssue().getLong("id") + "] " + issueEvent.getIssue().getString("summary"));
                this.log("Comment: " + issueEvent.getComment());
                this.log("Change Group: " + issueEvent.getChangeLog());
                this.log("Event Type: " + ComponentAccessor.getEventTypeManager().getEventType(issueEvent.getEventTypeId()).getName());
            } else if (event instanceof UserEvent) {
                UserEvent userEvent = (UserEvent)event;
                this.log("User: " + userEvent.getUser().getName() + " (" + userEvent.getUser().getEmailAddress() + ")");
            }
            this.log(" Time: " + event.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void log(String msg) {
        System.err.println("[DebugListener]: " + msg);
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getDescription() {
        return this.getI18NBean().getText("admin.listener.debug.desc");
    }
}

