/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity;

import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.EntityFactory;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;

public class Update {
    public static IntoContext into(String entityName) {
        return new IntoContext(entityName);
    }

    public static IntoContext into(EntityFactory entityFactory) {
        return new IntoContext(entityFactory.getEntityName());
    }

    public static class WhereContext {
        private final String entityName;
        private final FieldMap updateFields;
        private final FieldMap whereClause;

        private WhereContext(String entityName, FieldMap updateFields, FieldMap whereClause) {
            this.entityName = entityName;
            this.updateFields = updateFields;
            this.whereClause = whereClause;
        }

        public WhereContext andEqual(String fieldName, String value) {
            this.whereClause.add(fieldName, value);
            return this;
        }

        public WhereContext andEqual(String fieldName, Long value) {
            this.whereClause.add(fieldName, value);
            return this;
        }

        public int execute(EntityEngine entityEngine) {
            return entityEngine.execute(this);
        }

        public int execute(OfBizDelegator ofBizDelegator) {
            return ofBizDelegator.bulkUpdateByAnd(this.entityName, this.updateFields, this.whereClause);
        }
    }

    public static class SetContext {
        private final String entityName;
        private final FieldMap updateFields;

        private SetContext(String entityName, FieldMap updateFields) {
            this.entityName = entityName;
            this.updateFields = updateFields;
        }

        public SetContext set(String fieldName, Long value) {
            this.updateFields.add(fieldName, value);
            return this;
        }

        public SetContext set(String fieldName, String value) {
            this.updateFields.add(fieldName, value);
            return this;
        }

        public WhereContext all() {
            return new WhereContext(this.entityName, this.updateFields, new FieldMap());
        }

        public WhereContext whereIdEquals(Long id) {
            return new WhereContext(this.entityName, this.updateFields, new FieldMap("id", id));
        }

        public WhereContext whereEqual(String fieldName, String value) {
            return new WhereContext(this.entityName, this.updateFields, new FieldMap(fieldName, value));
        }

        public WhereContext whereEqual(String fieldName, Long value) {
            return new WhereContext(this.entityName, this.updateFields, new FieldMap(fieldName, value));
        }
    }

    public static class IntoContext {
        private final String entityName;

        private IntoContext(String entityName) {
            this.entityName = entityName;
        }

        public SetContext set(String fieldName, Long value) {
            return new SetContext(this.entityName, FieldMap.build(fieldName, value));
        }

        public SetContext set(String fieldName, String value) {
            return new SetContext(this.entityName, FieldMap.build(fieldName, value));
        }
    }
}

