/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.datetime;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.datetime.DateTimeFormatStrategy;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterSupplier;
import com.atlassian.jira.datetime.DateTimeSettings;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.datetime.Source;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@ThreadSafe
class DateTimeFormatterImpl
implements DateTimeFormatter {
    private final DateTimeFormatStrategy formatStrategy;
    private final Source<DateTimeZone> zone;
    private final Source<Locale> locale;
    private final DateTimeFormatterSupplier supplier;
    private final DateTimeSettings settings;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    DateTimeFormatterImpl(DateTimeFormatStrategy formatStrategy, DateTimeFormatterSupplier supplier, DateTimeSettings settings, JiraAuthenticationContext jiraAuthenticationContext, @Nullable Source<DateTimeZone> zone, @Nullable Source<Locale> locale) {
        this.formatStrategy = (DateTimeFormatStrategy)Preconditions.checkNotNull((Object)formatStrategy);
        this.supplier = (DateTimeFormatterSupplier)Preconditions.checkNotNull((Object)supplier);
        this.settings = (DateTimeSettings)Preconditions.checkNotNull((Object)settings);
        this.jiraAuthenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)jiraAuthenticationContext);
        this.zone = zone != null ? zone : new DefaultTimeZone();
        this.locale = locale != null ? locale : new DefaultLocale();
    }

    @Override
    public String format(Date date) {
        return this.formatStrategy.format(new DateTime((Object)date, this.zone.get()), this.locale.get());
    }

    @Override
    public Date parse(String text) {
        return this.formatStrategy.parse(text, this.zone.get(), this.locale.get());
    }

    @Override
    public DateTimeFormatter forLoggedInUser() {
        return this.supplier.getFormatterFor(this.getStyle(), new AuthContextTimeZone(), new AuthContextLocale());
    }

    @Override
    public DateTimeFormatter forUser(@Nullable User user) {
        return this.supplier.getFormatterFor(this.getStyle(), DateTimeFormatterImpl.constant(this.settings.timeZoneFor(user)), DateTimeFormatterImpl.constant(this.settings.localeFor(user)));
    }

    @Override
    public DateTimeFormatter withDefaultZone() {
        return this.withZone(null);
    }

    @Override
    public DateTimeFormatter withSystemZone() {
        SystemTimeZone systemZone = new SystemTimeZone();
        if (this.zone.equals(systemZone)) {
            return this;
        }
        return this.supplier.getFormatterFor(this.getStyle(), systemZone, this.locale);
    }

    @Override
    public DateTimeFormatter withZone(@Nullable TimeZone timeZone) {
        SourceTemplate timeZoneSource;
        SourceTemplate sourceTemplate = timeZoneSource = timeZone != null ? DateTimeFormatterImpl.constant(DateTimeZone.forTimeZone((TimeZone)timeZone)) : new DefaultTimeZone();
        if (this.zone.equals(timeZoneSource)) {
            return this;
        }
        return this.supplier.getFormatterFor(this.getStyle(), (Source<DateTimeZone>)((Object)timeZoneSource), this.locale);
    }

    @Override
    public DateTimeFormatter withDefaultLocale() {
        return this.withLocale(null);
    }

    @Override
    public DateTimeFormatter withLocale(@Nullable Locale locale) {
        SourceTemplate localeOverride;
        SourceTemplate sourceTemplate = localeOverride = locale != null ? DateTimeFormatterImpl.constant(locale) : new DefaultLocale();
        if (this.locale.equals(localeOverride)) {
            return this;
        }
        return this.supplier.getFormatterFor(this.getStyle(), this.zone, (Source<Locale>)((Object)localeOverride));
    }

    @Override
    public DateTimeFormatter withStyle(DateTimeStyle style) {
        if (style == this.getStyle()) {
            return this;
        }
        return this.supplier.getFormatterFor(style, this.zone, this.locale);
    }

    @Override
    public TimeZone getZone() {
        return this.zone.isOverride() ? this.zone.get().toTimeZone() : null;
    }

    @Override
    public Locale getLocale() {
        return this.locale.isOverride() ? this.locale.get() : null;
    }

    @Override
    public DateTimeStyle getStyle() {
        return this.formatStrategy.style();
    }

    @Override
    public String getFormatHint() {
        return this.formatStrategy.pattern();
    }

    static <T> ConstantSource<T> constant(T value) {
        return new ConstantSource<T>(value);
    }

    static abstract class SourceTemplate {
        SourceTemplate() {
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
        }
    }

    static abstract class FromSettingsSource<T>
    extends SourceTemplate
    implements Source<T> {
        FromSettingsSource() {
        }

        @Override
        public boolean isOverride() {
            return false;
        }
    }

    static class ConstantSource<T>
    extends SourceTemplate
    implements Source<T> {
        private final T override;

        public ConstantSource(T override) {
            this.override = Preconditions.checkNotNull(override);
        }

        @Override
        public boolean isOverride() {
            return true;
        }

        @Override
        public T get() {
            return this.override;
        }
    }

    class SystemTimeZone
    extends FromSettingsSource<DateTimeZone> {
        SystemTimeZone() {
        }

        @Override
        public DateTimeZone get() {
            return DateTimeZone.forTimeZone((TimeZone)TimeZone.getDefault());
        }
    }

    class DefaultTimeZone
    extends FromSettingsSource<DateTimeZone> {
        DefaultTimeZone() {
        }

        @Override
        public DateTimeZone get() {
            return DateTimeFormatterImpl.this.settings.timeZoneFor(null);
        }
    }

    class AuthContextTimeZone
    extends FromSettingsSource<DateTimeZone> {
        AuthContextTimeZone() {
        }

        @Override
        public DateTimeZone get() {
            return DateTimeFormatterImpl.this.settings.timeZoneFor(DateTimeFormatterImpl.this.jiraAuthenticationContext.getLoggedInUser());
        }
    }

    class DefaultLocale
    extends FromSettingsSource<Locale> {
        DefaultLocale() {
        }

        @Override
        public Locale get() {
            return DateTimeFormatterImpl.this.settings.localeFor(null);
        }
    }

    class AuthContextLocale
    extends FromSettingsSource<Locale> {
        AuthContextLocale() {
        }

        @Override
        public Locale get() {
            return DateTimeFormatterImpl.this.settings.localeFor(DateTimeFormatterImpl.this.jiraAuthenticationContext.getLoggedInUser());
        }
    }
}

