/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboard.permission;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.gadgets.GadgetState;
import com.atlassian.gadgets.Vote;
import com.atlassian.gadgets.dashboard.DashboardState;
import com.atlassian.gadgets.dashboard.spi.DashboardPermissionService;
import com.atlassian.gadgets.plugins.PluginGadgetSpec;
import com.atlassian.jira.dashboard.permission.GadgetPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class JiraGadgetPermissionManager
implements GadgetPermissionManager {
    private static final Logger log = Logger.getLogger(JiraGadgetPermissionManager.class);
    private static final String LOGIN_GADGET_PLUGIN_KEY = "com.atlassian.jira.gadgets:login-gadget";
    private static final Pattern PLUGIN_KEY_PATTERN = Pattern.compile(".*rest\\/gadgets\\/.*\\/g\\/([^\\/]+):([^\\/]+).*", 2);
    private final PermissionManager permissionManager;
    private final PluginAccessor pluginAccessor;
    private final DashboardPermissionService permissionService;

    public JiraGadgetPermissionManager(PermissionManager permissionManager, PluginAccessor pluginAccessor, DashboardPermissionService permissionService) {
        this.permissionManager = permissionManager;
        this.pluginAccessor = pluginAccessor;
        this.permissionService = permissionService;
    }

    @Override
    public Vote voteOn(PluginGadgetSpec pluginGadgetSpec, User remoteUser) {
        Assertions.notNull("pluginGadgetSpec", pluginGadgetSpec);
        String completeGadgetKey = pluginGadgetSpec.getPluginKey() + ":" + pluginGadgetSpec.getModuleKey();
        return this.voteOn(completeGadgetKey, remoteUser);
    }

    @Override
    public DashboardState filterGadgets(DashboardState dashboardState, User remoteUser) {
        Assertions.notNull("dashboardState", dashboardState);
        boolean isWritable = this.permissionService.isWritableBy(dashboardState.getId(), remoteUser == null ? null : remoteUser.getName());
        if (isWritable) {
            return dashboardState;
        }
        ArrayList columns = new ArrayList();
        for (Iterable columnIterable : dashboardState.getColumns()) {
            ArrayList<GadgetState> column = new ArrayList<GadgetState>();
            for (GadgetState state : columnIterable) {
                Vote vote;
                String gadgetKey = this.extractModuleKey(state.getGadgetSpecUri().toASCIIString());
                if (gadgetKey != null && (vote = this.voteOn(gadgetKey, remoteUser)).equals((Object)Vote.DENY)) continue;
                column.add(state);
            }
            columns.add(column);
        }
        return DashboardState.dashboard((DashboardState)dashboardState).columns(columns).build();
    }

    @Override
    public String extractModuleKey(String gadgetUri) {
        Matcher matcher = PLUGIN_KEY_PATTERN.matcher(gadgetUri);
        if (matcher.matches() && matcher.groupCount() == 2) {
            return matcher.group(1) + ":" + matcher.group(2);
        }
        return null;
    }

    @Override
    public Vote voteOn(String completeGadgetKey, User remoteUser) {
        String[] roles;
        if (completeGadgetKey.equals(LOGIN_GADGET_PLUGIN_KEY)) {
            if (remoteUser != null) {
                return Vote.DENY;
            }
            return Vote.ALLOW;
        }
        ModuleDescriptor moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(completeGadgetKey);
        if (moduleDescriptor == null) {
            return Vote.ALLOW;
        }
        String roleString = (String)moduleDescriptor.getParams().get("roles-required");
        if (StringUtils.isBlank((String)roleString)) {
            return Vote.ALLOW;
        }
        if (this.permissionManager.hasPermission(0, remoteUser)) {
            return Vote.ALLOW;
        }
        for (String role : roles = StringUtils.split((String)roleString)) {
            int permission = Permissions.getType(role);
            if (permission == -1) {
                log.warn((Object)("Invalid role-required specified for gadget '" + completeGadgetKey + "': '" + role + "'"));
                return Vote.PASS;
            }
            if (!(Permissions.isGlobalPermission(permission) ? !this.permissionManager.hasPermission(permission, remoteUser) : !this.hasProjectsPermission(permission, remoteUser))) continue;
            return Vote.DENY;
        }
        return Vote.ALLOW;
    }

    private boolean hasProjectsPermission(int permission, User user) {
        try {
            return this.permissionManager.hasProjects(permission, user);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

