/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboard;

import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.GadgetState;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.DashboardNotFoundException;
import com.atlassian.gadgets.dashboard.DashboardState;
import com.atlassian.gadgets.dashboard.spi.DashboardStateStore;
import com.atlassian.gadgets.dashboard.spi.DashboardStateStoreException;
import com.atlassian.gadgets.dashboard.spi.changes.DashboardChange;
import com.atlassian.jira.dashboard.DashboardUtil;
import com.atlassian.jira.dashboard.JiraDashboardChangeVisitor;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.portal.PortalPageManager;
import com.atlassian.jira.portal.PortalPageStore;
import com.atlassian.jira.portal.PortletConfiguration;
import com.atlassian.jira.portal.PortletConfigurationStore;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.util.concurrent.Function;
import com.atlassian.util.concurrent.ManagedLock;
import com.atlassian.util.concurrent.ManagedLocks;
import com.atlassian.util.concurrent.Supplier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class JiraDashboardStateStoreManager
implements DashboardStateStore {
    private static final Logger log = Logger.getLogger(JiraDashboardStateStoreManager.class);
    private final PortalPageStore portalPageStore;
    private final PortletConfigurationStore portletConfigurationStore;
    private final PortalPageManager portalPageManager;
    private final Function<DashboardId, ManagedLock.ReadWrite> lockFactory = ManagedLocks.weakReadWriteManagedLockFactory((Function)new Function<DashboardId, Long>(){

        public Long get(DashboardId dashboardId) {
            return DashboardUtil.toLong(dashboardId);
        }
    });
    private final Function<PortletConfiguration, GadgetState> toGadgetState = new Function<PortletConfiguration, GadgetState>(){

        public GadgetState get(PortletConfiguration portletConfiguration) {
            URI gadgetUri = portletConfiguration.getGadgetURI();
            if (gadgetUri == null) {
                gadgetUri = URI.create("/invalid/legacy/portlet/Please_remove_this_gadget_from_your_dashboard!");
            }
            return GadgetState.gadget((GadgetId)GadgetId.valueOf((String)portletConfiguration.getId().toString())).specUri(gadgetUri).color(portletConfiguration.getColor()).userPrefs(portletConfiguration.getUserPrefs()).build();
        }
    };

    public JiraDashboardStateStoreManager(PortalPageStore portalPageStore, PortletConfigurationStore portletConfigurationStore, PortalPageManager portalPageManager) {
        this.portalPageStore = portalPageStore;
        this.portletConfigurationStore = portletConfigurationStore;
        this.portalPageManager = portalPageManager;
    }

    public DashboardState retrieve(final DashboardId dashboardId) throws DashboardNotFoundException, DashboardStateStoreException {
        Assertions.notNull("dashboardId", dashboardId);
        return (DashboardState)((ManagedLock.ReadWrite)this.lockFactory.get((Object)dashboardId)).read().withLock((Supplier)new Supplier<DashboardState>(){

            public DashboardState get() {
                Long portalPageId = DashboardUtil.toLong(dashboardId);
                try {
                    PortalPage portalPage = JiraDashboardStateStoreManager.this.portalPageStore.getPortalPage(portalPageId);
                    if (portalPage == null) {
                        throw new DashboardNotFoundException(dashboardId);
                    }
                    List<List<PortletConfiguration>> pcColumns = JiraDashboardStateStoreManager.this.portalPageManager.getPortletConfigurations(portalPageId);
                    ArrayList dashboardColumns = new ArrayList();
                    for (List<PortletConfiguration> pcColumn : pcColumns) {
                        ArrayList<Object> column = new ArrayList<Object>();
                        for (PortletConfiguration portletConfiguration : pcColumn) {
                            column.add(JiraDashboardStateStoreManager.this.toGadgetState.get((Object)portletConfiguration));
                        }
                        dashboardColumns.add(column);
                    }
                    return DashboardState.dashboard((DashboardId)dashboardId).title(portalPage.getName()).version(portalPage.getVersion() == null ? 1L : portalPage.getVersion()).columns(dashboardColumns).layout(portalPage.getLayout()).build();
                }
                catch (DataAccessException e) {
                    throw new DashboardStateStoreException("Unknown error occurred while retrieving dashboard with id '" + portalPageId + "'.", (Throwable)e);
                }
            }
        });
    }

    public DashboardState update(final DashboardState dashboardState, final Iterable<DashboardChange> dashboardChangeIterable) throws DashboardStateStoreException {
        Assertions.notNull("dashboardState", dashboardState);
        Assertions.notNull("dashboardChangeIterable", dashboardChangeIterable);
        final DashboardId dashboardId = dashboardState.getId();
        try {
            return (DashboardState)((ManagedLock.ReadWrite)this.lockFactory.get((Object)dashboardId)).write().withLock((Supplier)new Supplier<DashboardState>(){

                public DashboardState get() {
                    boolean optimisticLock = JiraDashboardStateStoreManager.this.portalPageStore.updatePortalPageOptimisticLock(DashboardUtil.toLong(dashboardId), dashboardState.getVersion());
                    if (!optimisticLock) {
                        throw new DashboardStateStoreException("Dashboard with id '" + dashboardId + "' is out of sync with the currently persisted state.");
                    }
                    if (!dashboardChangeIterable.iterator().hasNext()) {
                        return JiraDashboardStateStoreManager.this.storeDashboardState(dashboardState);
                    }
                    new JiraDashboardChangeVisitor(dashboardState, JiraDashboardStateStoreManager.this.portletConfigurationStore, JiraDashboardStateStoreManager.this.portalPageStore).accept(dashboardChangeIterable);
                    DashboardState storedState = JiraDashboardStateStoreManager.this.retrieve(dashboardId);
                    if (!storedState.equals((Object)dashboardState)) {
                        log.warn((Object)("Stored state for dashboard with id '" + dashboardId + "' is not the same as in memory state.  Trying to rewrite the entire state..."));
                        return JiraDashboardStateStoreManager.this.storeDashboardState(dashboardState);
                    }
                    return storedState;
                }
            });
        }
        catch (DataAccessException e) {
            throw new DashboardStateStoreException("Error updating dashboard state with id '" + dashboardId + "'.", (Throwable)e);
        }
    }

    public void remove(DashboardId dashboardId) throws DashboardStateStoreException {
        Assertions.notNull("dashboardId", dashboardId);
        final Long portalPageId = DashboardUtil.toLong(dashboardId);
        try {
            ((ManagedLock.ReadWrite)this.lockFactory.get((Object)dashboardId)).write().withLock(new Runnable(){

                @Override
                public void run() {
                    JiraDashboardStateStoreManager.this.portalPageManager.delete(portalPageId);
                }
            });
        }
        catch (DataAccessException e) {
            throw new DashboardStateStoreException("Error removing dashboard state with id'" + dashboardId + "'.", (Throwable)e);
        }
    }

    public DashboardState findDashboardWithGadget(GadgetId gadgetId) throws DashboardNotFoundException {
        Assertions.notNull("gagdetId", gadgetId);
        try {
            PortletConfiguration portletConfiguration = this.portletConfigurationStore.getByPortletId(DashboardUtil.toLong(gadgetId));
            if (portletConfiguration != null) {
                return this.retrieve(DashboardId.valueOf((String)Long.toString(portletConfiguration.getDashboardPageId())));
            }
            throw new DashboardStateStoreException("Gadget with id '" + gadgetId + "' not found!");
        }
        catch (DataAccessException e) {
            throw new DashboardStateStoreException("Error looking up gadget with id '" + gadgetId + "'.", (Throwable)e);
        }
    }

    private DashboardState storeDashboardState(DashboardState dashboardState) {
        Assertions.notNull("dashboardState", dashboardState);
        DashboardId dashboardId = dashboardState.getId();
        long portalPageId = DashboardUtil.toLong(dashboardId);
        PortalPage portalPage = this.portalPageStore.getPortalPage(portalPageId);
        if (portalPage == null) {
            throw new DashboardStateStoreException("No portal page found with id '" + portalPageId + "'");
        }
        this.updatePortalPage(portalPage, dashboardState);
        Map<Long, PortletConfiguration> oldPortlets = this.getCurrentPortletConfigurationsMap(portalPageId);
        for (DashboardState.ColumnIndex columnIndex : dashboardState.getLayout().getColumnRange()) {
            int row = 0;
            for (GadgetState gadgetState : dashboardState.getGadgetsInColumn(columnIndex)) {
                long gadgetId = DashboardUtil.toLong(gadgetState.getId());
                if (oldPortlets.containsKey(gadgetId)) {
                    PortletConfiguration oldPortletConfiguration = oldPortlets.get(gadgetId);
                    oldPortletConfiguration.setColumn(columnIndex.index());
                    oldPortletConfiguration.setRow(row++);
                    oldPortletConfiguration.setColor(gadgetState.getColor());
                    oldPortletConfiguration.setUserPrefs(gadgetState.getUserPrefs());
                    this.portletConfigurationStore.store(oldPortletConfiguration);
                    oldPortlets.remove(gadgetId);
                    continue;
                }
                this.portletConfigurationStore.addGadget(portalPageId, gadgetId, columnIndex.index(), row++, gadgetState.getGadgetSpecUri(), gadgetState.getColor(), gadgetState.getUserPrefs());
            }
        }
        for (PortletConfiguration existingPortlet : oldPortlets.values()) {
            this.portletConfigurationStore.delete(existingPortlet);
        }
        return this.retrieve(dashboardId);
    }

    private void updatePortalPage(PortalPage portalPage, DashboardState dashboardState) {
        if (!portalPage.getLayout().equals((Object)dashboardState.getLayout()) || !StringUtils.equals((String)portalPage.getName(), (String)dashboardState.getTitle())) {
            PortalPage.Builder builder = PortalPage.portalPage(portalPage);
            builder.name(dashboardState.getTitle());
            builder.layout(dashboardState.getLayout());
            this.portalPageStore.update(builder.build());
        }
    }

    private Map<Long, PortletConfiguration> getCurrentPortletConfigurationsMap(Long portalPageId) {
        HashMap<Long, PortletConfiguration> ret = new HashMap<Long, PortletConfiguration>();
        List<PortletConfiguration> list = this.portletConfigurationStore.getByPortalPage(portalPageId);
        for (PortletConfiguration portletConfiguration : list) {
            ret.put(portletConfiguration.getId(), portletConfiguration);
        }
        return ret;
    }
}

