/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded;

import org.apache.commons.lang.StringUtils;
import sun.net.util.IPAddressUtil;

public class RemoteAddressHelper {
    public static boolean isValidIPNotation(String address) {
        return RemoteAddressHelper.getAddressInBytes(StringUtils.substringBefore((String)address, (String)"/")) != null;
    }

    private static byte[] getAddressInBytes(String address) {
        if (address == null || address.length() == 0) {
            return null;
        }
        boolean ipv6Expected = false;
        if (address.charAt(0) == '[') {
            if (address.length() > 2 && address.charAt(address.length() - 1) == ']') {
                address = address.substring(1, address.length() - 1);
                ipv6Expected = true;
            } else {
                return null;
            }
        }
        if (Character.digit(address.charAt(0), 16) != -1 || address.charAt(0) == ':') {
            byte[] addr = IPAddressUtil.textToNumericFormatV4(address);
            if (addr == null) {
                return IPAddressUtil.textToNumericFormatV6(address);
            }
            return ipv6Expected ? null : addr;
        }
        return null;
    }
}

