/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.db;

import com.atlassian.jira.configurator.config.Settings;
import com.atlassian.jira.configurator.config.ValidationException;
import com.atlassian.jira.configurator.db.DatabaseConfigPanel;
import com.atlassian.jira.configurator.gui.ConfigPanelBuilder;
import com.atlassian.jira.exception.ParseException;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OracleConfigPanel
extends DatabaseConfigPanel {
    private JTextField tfHostname = new JTextField(20);
    private JTextField tfPort = new JTextField("1521", 20);
    private JTextField tfSid = new JTextField(20);
    private JTextField tfUsername = new JTextField(20);
    private JTextField tfPassword = new JTextField(20);
    private JPanel configPanel;

    @Override
    public String getDisplayName() {
        return "Oracle";
    }

    @Override
    public String getClassName() {
        return "oracle.jdbc.OracleDriver";
    }

    @Override
    public String getUrl(String jiraHome) {
        String url = "jdbc:oracle:thin:@" + this.tfHostname.getText().trim();
        url = url + ':' + this.tfPort.getText().trim();
        return url + ":" + this.tfSid.getText();
    }

    @Override
    public String getUsername() {
        return this.tfUsername.getText();
    }

    @Override
    public String getPassword() {
        return this.tfPassword.getText();
    }

    @Override
    public String getSchemaName() {
        return null;
    }

    @Override
    public JPanel getPanel() {
        if (this.configPanel == null) {
            ConfigPanelBuilder panelBuilder = new ConfigPanelBuilder();
            panelBuilder.add("Hostname", this.tfHostname);
            this.tfHostname.setToolTipText("The hostname or IP address of the Oracle server");
            panelBuilder.add("Port", this.tfPort);
            this.tfPort.setToolTipText("The port number that Oracle is running on. (Default is 1521)");
            panelBuilder.add("SID", this.tfSid);
            this.tfSid.setToolTipText("System ID of the Oracle server database instance. (eg 'ORCL'. For Express Edition use 'XE')");
            panelBuilder.add("Username", this.tfUsername);
            this.tfUsername.setToolTipText("The username used to login");
            panelBuilder.add("Password", this.tfPassword);
            this.tfPassword.setToolTipText("The password used to login");
            this.configPanel = panelBuilder.getPanel();
        }
        return this.configPanel;
    }

    @Override
    public void setSettings(Settings settings) throws ParseException {
        this.tfUsername.setText(settings.getDbUsername());
        this.tfPassword.setText(settings.getDbPassword());
        OracleConnectionProperties connectionProperties = this.parseUrl(settings.getJdbcUrl());
        this.tfHostname.setText(connectionProperties.host);
        this.tfPort.setText(connectionProperties.port);
        this.tfSid.setText(connectionProperties.sid);
    }

    OracleConnectionProperties parseUrl(String jdbcUrl) throws ParseException {
        OracleConnectionProperties oracleConnectionProperties = new OracleConnectionProperties();
        if (!jdbcUrl.startsWith("jdbc:oracle:thin:")) {
            throw new ParseException("Unable to parse the Oracle JDBC URL '" + jdbcUrl + "'. It should start with protocol prefix 'jdbc:oracle:thin:'.");
        }
        String stripped = jdbcUrl.substring("jdbc:oracle:thin:".length());
        String[] split = stripped.split("@", 2);
        if (split.length == 1) {
            throw new ParseException("Unable to parse the Oracle JDBC URL '" + jdbcUrl + "'. Expected to find a '@' before the host name.");
        }
        String props = split[1];
        if (props.startsWith("//")) {
            String[] hostPort_Sid = (props = props.substring(2)).split("/", 2);
            if (hostPort_Sid.length == 1) {
                throw new ParseException("Unable to parse the Oracle JDBC URL '" + jdbcUrl + "'. Missing '/' before the SID.");
            }
            oracleConnectionProperties.sid = hostPort_Sid[1];
            String[] hostPort = hostPort_Sid[0].split(":");
            oracleConnectionProperties.host = hostPort[0];
            oracleConnectionProperties.port = hostPort.length == 1 ? "" : hostPort[1];
        } else {
            String[] host_Port_Sid = props.split(":", 3);
            if (host_Port_Sid.length == 1) {
                throw new ParseException("Unable to parse the Oracle JDBC URL '" + jdbcUrl + "'. Missing ':' before the SID.");
            }
            if (host_Port_Sid.length == 2) {
                oracleConnectionProperties.host = host_Port_Sid[0];
                oracleConnectionProperties.port = "";
                oracleConnectionProperties.sid = host_Port_Sid[1];
            } else {
                oracleConnectionProperties.host = host_Port_Sid[0];
                oracleConnectionProperties.port = host_Port_Sid[1];
                oracleConnectionProperties.sid = host_Port_Sid[2];
            }
        }
        return oracleConnectionProperties;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.tfPort.getText().trim().length() == 0) {
            throw new ValidationException("Please supply a Port Number to connect to. (Default Oracle port is 1521).");
        }
        this.validatePortNumber(this.tfPort.getText());
    }

    class OracleConnectionProperties {
        String host;
        String port;
        String sid;

        OracleConnectionProperties() {
        }
    }
}

