/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.db;

import com.atlassian.jira.configurator.config.Settings;
import com.atlassian.jira.configurator.config.ValidationException;
import com.atlassian.jira.configurator.db.ConnectionConfig;
import com.atlassian.jira.configurator.db.DatabaseConfigPanel;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;

public abstract class AbstractConnectionConfig
implements ConnectionConfig {
    @Override
    public void saveSettings(Settings newSettings) throws ValidationException {
        newSettings.setJdbcDriverClass(this.getClassName());
        newSettings.setJdbcUrl(this.getUrl());
        newSettings.setDbUsername(this.getUsername());
        newSettings.setDbPassword(this.getPassword());
    }

    @Override
    public void testConnection() throws ClassNotFoundException, SQLException, ValidationException {
        Driver driver;
        Class<?> driverClass = Class.forName(this.getClassName(), true, AbstractConnectionConfig.getDriverClassLoader());
        try {
            driver = (Driver)driverClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        DriverManager.setLoginTimeout(10);
        Properties props = new Properties();
        props.setProperty("user", this.getUsername());
        props.setProperty("password", this.getPassword());
        driver.connect(this.getUrl(), props);
    }

    private static ClassLoader getDriverClassLoader() {
        ArrayList<URL> jars = new ArrayList<URL>();
        File libDir = new File("../lib");
        if (!libDir.exists() || !libDir.isDirectory()) {
            return DatabaseConfigPanel.class.getClassLoader();
        }
        for (File file : libDir.listFiles()) {
            if (!file.getName().endsWith(".jar")) continue;
            try {
                jars.add(file.toURL());
            }
            catch (MalformedURLException ex) {
                System.err.println("Unexpected MalformedURLException on file '" + file.getAbsolutePath() + "'.");
                ex.printStackTrace(System.err);
            }
        }
        return new URLClassLoader(jars.toArray(new URL[jars.size()]));
    }
}

