/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.config;

import com.atlassian.jira.configurator.config.DatabaseType;

public class Settings {
    private String jiraHome;
    private String jdbcDriverClass;
    private String jdbcUrl;
    private String dbUsername;
    private String dbPassword;
    private String schemaName;
    private String dbPoolSize = "15";
    private String httpPort;
    private String controlPort;

    public String getJiraHome() {
        return this.jiraHome;
    }

    public void setJiraHome(String jiraHome) {
        this.jiraHome = jiraHome;
    }

    public String getJdbcDriverClass() {
        return this.jdbcDriverClass;
    }

    public void setJdbcDriverClass(String jdbcDriverClass) {
        this.jdbcDriverClass = jdbcDriverClass;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getDbUsername() {
        return this.dbUsername;
    }

    public void setDbUsername(String dbUsername) {
        this.dbUsername = dbUsername;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getDbPoolSize() {
        return this.dbPoolSize;
    }

    public void setDbPoolSize(String dbPoolSize) {
        this.dbPoolSize = dbPoolSize;
    }

    public String getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(String httpPort) {
        this.httpPort = httpPort;
    }

    public String getControlPort() {
        return this.controlPort;
    }

    public void setControlPort(String controlPort) {
        this.controlPort = controlPort;
    }

    public DatabaseType getDatabaseType() {
        if (this.jdbcDriverClass == null) {
            return DatabaseType.HSQL;
        }
        if (this.jdbcDriverClass.equals("org.hsqldb.jdbcDriver")) {
            return DatabaseType.HSQL;
        }
        if (this.jdbcDriverClass.equals("com.mysql.jdbc.Driver")) {
            return DatabaseType.MY_SQL;
        }
        if (this.jdbcDriverClass.equals("oracle.jdbc.OracleDriver")) {
            return DatabaseType.ORACLE;
        }
        if (this.jdbcDriverClass.equals("org.postgresql.Driver")) {
            return DatabaseType.POSTGRES;
        }
        if (this.jdbcDriverClass.equals("net.sourceforge.jtds.jdbc.Driver")) {
            return DatabaseType.SQL_SERVER;
        }
        if (this.jdbcDriverClass.equals("com.microsoft.jdbc.sqlserver.SQLServerDriver")) {
            return DatabaseType.SQL_SERVER;
        }
        throw new IllegalStateException("Unknown JDBC Driver Class " + this.jdbcDriverClass);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Settings settings = (Settings)o;
        if (this.controlPort != null ? !this.controlPort.equals(settings.controlPort) : settings.controlPort != null) {
            return false;
        }
        if (this.dbPassword != null ? !this.dbPassword.equals(settings.dbPassword) : settings.dbPassword != null) {
            return false;
        }
        if (this.dbPoolSize != null ? !this.dbPoolSize.equals(settings.dbPoolSize) : settings.dbPoolSize != null) {
            return false;
        }
        if (this.dbUsername != null ? !this.dbUsername.equals(settings.dbUsername) : settings.dbUsername != null) {
            return false;
        }
        if (this.httpPort != null ? !this.httpPort.equals(settings.httpPort) : settings.httpPort != null) {
            return false;
        }
        if (this.jdbcDriverClass != null ? !this.jdbcDriverClass.equals(settings.jdbcDriverClass) : settings.jdbcDriverClass != null) {
            return false;
        }
        if (this.jdbcUrl != null ? !this.jdbcUrl.equals(settings.jdbcUrl) : settings.jdbcUrl != null) {
            return false;
        }
        if (this.jiraHome != null ? !this.jiraHome.equals(settings.jiraHome) : settings.jiraHome != null) {
            return false;
        }
        return !(this.schemaName != null ? !this.schemaName.equals(settings.schemaName) : settings.schemaName != null);
    }
}

