/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.util;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.PropertiesUtil;
import com.atlassian.util.concurrent.Assertions;

public interface IndexingConfiguration {
    public int getIndexLockWaitTime();

    public int getMaxReindexes();

    public int getIssuesToForceOptimize();

    public boolean isIndexingEnabled();

    public void disableIndexing();

    public void enableIndexing();

    public static class PropertiesAdapter
    implements IndexingConfiguration {
        private final ApplicationProperties applicationProperties;

        public PropertiesAdapter(ApplicationProperties applicationProperties) {
            this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        }

        @Override
        public int getIndexLockWaitTime() {
            return PropertiesUtil.getIntProperty(this.applicationProperties, "jira.index.lock.waittime", 30000);
        }

        @Override
        public int getMaxReindexes() {
            return PropertiesUtil.getIntProperty(this.applicationProperties, "jira.index.max.reindexes", 4000);
        }

        @Override
        public int getIssuesToForceOptimize() {
            return PropertiesUtil.getIntProperty(this.applicationProperties, "jira.index.update.bulk.optimization", 400);
        }

        @Override
        public boolean isIndexingEnabled() {
            return this.applicationProperties.getOption("jira.option.indexing");
        }

        @Override
        public void enableIndexing() {
            this.applicationProperties.setOption("jira.option.indexing", true);
        }

        @Override
        public void disableIndexing() {
            this.applicationProperties.setOption("jira.option.indexing", false);
        }

        private static final class Defaults {
            private static final int MAX_REINDEXES = 4000;
            private static final int INDEX_LOCK_WAIT_TIME = 30000;
            private static final int ISSUES_TO_FORCE_OPTIMIZE = 400;

            private Defaults() {
            }
        }
    }
}

