/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.util;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.config.util.IndexPathService;
import com.atlassian.jira.security.PermissionManager;

public class DefaultIndexPathService
implements IndexPathService {
    private final IndexPathManager indexPathManager;
    private final PermissionManager permissionManager;

    public DefaultIndexPathService(IndexPathManager indexPathManager, PermissionManager permissionManager) {
        this.indexPathManager = indexPathManager;
        this.permissionManager = permissionManager;
    }

    @Override
    public String getIndexRootPath(JiraServiceContext serviceContext) {
        if (this.permissionManager.hasPermission(44, serviceContext.getLoggedInUser())) {
            return this.indexPathManager.getIndexRootPath();
        }
        serviceContext.getErrorCollection().addErrorMessage(serviceContext.getI18nBean().getText("admin.errors.indexpath.no.permission"));
        return null;
    }

    @Override
    public String getIssueIndexPath(JiraServiceContext serviceContext) {
        if (this.permissionManager.hasPermission(44, serviceContext.getLoggedInUser())) {
            return this.indexPathManager.getIssueIndexPath();
        }
        serviceContext.getErrorCollection().addErrorMessage(serviceContext.getI18nBean().getText("admin.errors.indexpath.no.permission"));
        return null;
    }

    @Override
    public String getCommentIndexPath(JiraServiceContext serviceContext) {
        if (this.permissionManager.hasPermission(44, serviceContext.getLoggedInUser())) {
            return this.indexPathManager.getCommentIndexPath();
        }
        serviceContext.getErrorCollection().addErrorMessage(serviceContext.getI18nBean().getText("admin.errors.indexpath.no.permission"));
        return null;
    }

    @Override
    public String getPluginIndexRootPath(JiraServiceContext serviceContext) {
        if (this.permissionManager.hasPermission(44, serviceContext.getLoggedInUser())) {
            return this.indexPathManager.getPluginIndexRootPath();
        }
        serviceContext.getErrorCollection().addErrorMessage(serviceContext.getI18nBean().getText("admin.errors.indexpath.no.permission"));
        return null;
    }

    @Override
    public String getSharedEntityIndexPath(JiraServiceContext serviceContext) {
        if (this.permissionManager.hasPermission(44, serviceContext.getLoggedInUser())) {
            return this.indexPathManager.getSharedEntityIndexPath();
        }
        serviceContext.getErrorCollection().addErrorMessage(serviceContext.getI18nBean().getText("admin.errors.indexpath.no.permission"));
        return null;
    }

    @Override
    public void setIndexRootPath(JiraServiceContext serviceContext, String indexPath) {
        if (this.permissionManager.hasPermission(44, serviceContext.getLoggedInUser())) {
            this.indexPathManager.setIndexRootPath(indexPath);
        } else {
            serviceContext.getErrorCollection().addErrorMessage(serviceContext.getI18nBean().getText("admin.errors.indexpath.no.permission"));
        }
    }

    @Override
    public void setUseDefaultDirectory(JiraServiceContext serviceContext) {
        if (this.permissionManager.hasPermission(44, serviceContext.getLoggedInUser())) {
            this.indexPathManager.setUseDefaultDirectory();
        } else {
            serviceContext.getErrorCollection().addErrorMessage(serviceContext.getI18nBean().getText("admin.errors.indexpath.no.permission"));
        }
    }
}

