/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties;

import com.atlassian.jira.bc.admin.ApplicationPropertyMetadata;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.validation.ApplicationPropertyEnumerator;
import com.atlassian.validation.EnumValidator;
import com.atlassian.validation.Validator;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

class MetadataLoader {
    private static final Logger log = Logger.getLogger(MetadataLoader.class);

    MetadataLoader() {
    }

    LinkedHashMap<String, ApplicationPropertyMetadata> loadMetadata(String xmlFilename) throws DataAccessException {
        try {
            log.debug((Object)("Loading application properties metadata from " + xmlFilename));
            InputStream mxml = this.getClass().getClassLoader().getResourceAsStream(xmlFilename);
            return this.loadMetadata(mxml, xmlFilename);
        }
        catch (Exception e) {
            throw new DataAccessException("Cannot load the application properties metadata file " + xmlFilename, e);
        }
    }

    LinkedHashMap<String, ApplicationPropertyMetadata> loadMetadata(InputStream stream, String streamDescriptor) throws DocumentException {
        LinkedHashMap<String, ApplicationPropertyMetadata> metadataMap = new LinkedHashMap<String, ApplicationPropertyMetadata>();
        SAXReader reader = new SAXReader();
        Document doc = reader.read(stream);
        Element root = doc.getRootElement();
        Iterator properties = root.element("properties").elementIterator();
        while (properties.hasNext()) {
            boolean requiresRestart;
            Element enm;
            Element typeElement;
            Element property = (Element)properties.next();
            String key = property.elementText("key");
            String defaultValue = property.elementText("default-value");
            String type = property.elementText("type");
            if (type == null) {
                type = "string";
            }
            String validator = property.elementText("validator");
            Supplier validatorObject = null;
            HashMap enumerators = Maps.newHashMap();
            if (StringUtils.isBlank((String)type) && (typeElement = property.element("type")) != null && (enm = typeElement.element("enum")) != null) {
                type = "enum";
                ArrayList<String> options = new ArrayList<String>();
                Iterator optionIter = enm.elementIterator("option");
                while (optionIter.hasNext()) {
                    Element optionElem = (Element)optionIter.next();
                    String optionValue = optionElem.getText();
                    if (optionValue == null || "".equals(optionValue.trim())) {
                        throw new IllegalArgumentException("No option may be blank");
                    }
                    options.add(optionValue);
                }
                enumerators.put(key, ApplicationPropertyEnumerator.of(options));
                validatorObject = Suppliers.ofInstance((Object)new EnumValidator((ApplicationPropertyEnumerator)enumerators.get(key)));
            }
            String name = property.elementText("name");
            String desc = property.elementText("description");
            if (name == null) {
                name = key;
            }
            boolean userEditable = !"false".equalsIgnoreCase(property.elementText("user-editable"));
            boolean bl = requiresRestart = !"false".equalsIgnoreCase(property.elementText("requires-restart"));
            if (key != null) {
                ApplicationPropertyMetadata metadata = validatorObject == null ? new ApplicationPropertyMetadata(key, type, defaultValue, validator, userEditable, requiresRestart, name, desc, (ApplicationPropertyEnumerator)enumerators.get(key)) : new ApplicationPropertyMetadata(key, type, defaultValue, (Supplier<? extends Validator>)validatorObject, userEditable, requiresRestart, name, desc, (ApplicationPropertyEnumerator)enumerators.get(key));
                metadataMap.put(key, metadata);
                continue;
            }
            log.error((Object)(streamDescriptor + " contains null key"));
        }
        return metadataMap;
    }
}

