/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.ApplicationPropertiesStore;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.util.LocaleParser;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public class ApplicationPropertiesImpl
implements ApplicationProperties,
Startable {
    private static final Logger log = Logger.getLogger(ApplicationPropertiesImpl.class);
    private final Locale defaultLocale = Locale.getDefault();
    private ApplicationPropertiesStore applicationPropertiesStore;

    public ApplicationPropertiesImpl(ApplicationPropertiesStore applicationPropertiesStore) {
        this.applicationPropertiesStore = applicationPropertiesStore;
    }

    @Override
    public void start() throws Exception {
        ComponentManager.getComponent(EventPublisher.class).register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }

    @Override
    public String getText(String name) {
        return this.applicationPropertiesStore.getTextFromDb(name);
    }

    @Override
    public void setText(String name, String value) {
        this.applicationPropertiesStore.setText(name, value);
    }

    @Override
    public String getString(String name) {
        return this.applicationPropertiesStore.getStringFromDb(name);
    }

    @Override
    public Collection<String> getDefaultKeys() {
        return this.getDefaultProperties().keySet();
    }

    @Override
    public String getDefaultBackedString(String name) {
        return this.applicationPropertiesStore.getString(name);
    }

    @Override
    public String getDefaultBackedText(String name) {
        String value = null;
        try {
            value = this.getText(name);
        }
        catch (Exception e) {
            log.warn((Object)("Exception getting property '" + name + "' from database. Using default"));
        }
        if (value == null) {
            value = this.getDefaultString(name);
        }
        return value;
    }

    @Override
    public String getDefaultString(String name) {
        return this.getDefaultProperties().get(name);
    }

    @Override
    public void setString(String name, String value) {
        this.applicationPropertiesStore.setString(name, value);
    }

    @Override
    public boolean getOption(String key) {
        return this.applicationPropertiesStore.getOption(key);
    }

    @Override
    public Collection<String> getKeys() {
        return this.applicationPropertiesStore.getKeysStoredInDb();
    }

    @Override
    public Map<String, Object> asMap() {
        return this.applicationPropertiesStore.getPropertiesAsMap();
    }

    @Override
    public void setOption(String key, boolean value) {
        this.applicationPropertiesStore.setOption(key, value);
    }

    @Override
    public String getEncoding() {
        String encoding = this.getString("webwork.i18n.encoding");
        if (!TextUtils.stringSet((String)encoding)) {
            encoding = "UTF-8";
            this.setString("webwork.i18n.encoding", encoding);
        }
        return encoding;
    }

    @Override
    public String getMailEncoding() {
        String encoding = this.getDefaultBackedString("jira.i18n.email.encoding");
        if (!TextUtils.stringSet((String)encoding)) {
            encoding = this.getEncoding();
        }
        return encoding;
    }

    @Override
    public String getContentType() {
        return "text/html; charset=" + this.getEncoding();
    }

    @Override
    public void refresh() {
        this.applicationPropertiesStore.refreshDbProperties();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("propertiesManager", (Object)this.applicationPropertiesStore).toString();
    }

    private Map<String, String> getDefaultProperties() {
        return this.applicationPropertiesStore.getDefaultsWithOverlays();
    }

    @Override
    public Locale getDefaultLocale() {
        String localeString = this.getDefaultBackedString("jira.i18n.default.locale");
        if (localeString != null) {
            return LocaleParser.parseLocale(localeString);
        }
        return this.defaultLocale;
    }

    @Override
    public Collection<String> getStringsWithPrefix(String prefix) {
        return this.applicationPropertiesStore.getStringsWithPrefixFromDb(prefix);
    }
}

