/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.database;

import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationLoader;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.database.JdbcDatasource;
import com.atlassian.jira.config.properties.PropertiesManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.startup.SystemTenant;
import com.atlassian.jira.util.ComponentLocator;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.util.concurrent.LazyReference;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.EntityConfigUtil;

public class DatabaseConfigurationManagerImpl
implements DatabaseConfigurationManager {
    private static final Logger log = Logger.getLogger(DatabaseConfigurationManagerImpl.class);
    private static final int DEFAULT_POOL_SIZE = 20;
    private static final String ACTIVATED = "post-database-activated";
    private static final String CONFIGURED_PRE_ACTIVATED = "post-database-configured-but-pre-database-activated";
    private final ReentrantLock setupLock = new ReentrantLock();
    private final LinkedBlockingQueue<Runnable> postDbSetupQueue = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<Runnable> postDbConfiguredQueue = new LinkedBlockingQueue();
    private final AtomicReference<DatabaseConfig> configCache = new AtomicReference();
    private final AtomicBoolean possiblySetup = new AtomicBoolean(true);
    private final AtomicBoolean definitelySetup = new AtomicBoolean(false);
    private final DatabaseConfigurationLoader databaseConfigLoader;
    private final ComponentLocator componentLocator;
    private final LazyReference<DatabaseConfig> internalConfig;
    private volatile boolean ofBizConfigured = false;

    public DatabaseConfigurationManagerImpl(final JiraHome jiraHome, DatabaseConfigurationLoader databaseConfigLoader, ComponentLocator componentLocator) {
        this.databaseConfigLoader = databaseConfigLoader;
        this.componentLocator = componentLocator;
        this.internalConfig = new LazyReference<DatabaseConfig>(){

            protected DatabaseConfig create() throws Exception {
                return DatabaseConfigurationManagerImpl.this.createInternalConfig(jiraHome);
            }
        };
    }

    private DatabaseConfig createInternalConfig(JiraHome jiraHome) {
        String jdbcUrl = "jdbc:hsqldb:" + jiraHome.getHomePath() + "/database/jiradb";
        String driver = "org.hsqldb.jdbcDriver";
        JdbcDatasource datasource = new JdbcDatasource(jdbcUrl, "org.hsqldb.jdbcDriver", "sa", "", 20, null, 4000L, 5000L);
        return new DatabaseConfig("hsql", "PUBLIC", datasource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDatabaseConfiguration(DatabaseConfig databaseConfiguration) {
        this.setupLock.lock();
        try {
            this.databaseConfigLoader.saveDatabaseConfiguration(databaseConfiguration);
            this.configCache.set(databaseConfiguration);
            this.possiblySetup.set(true);
        }
        finally {
            this.setupLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseConfig getDatabaseConfiguration() {
        try {
            this.setupLock.lock();
            DatabaseConfig dbConfig = this.configCache.get();
            if (dbConfig == null) {
                try {
                    dbConfig = this.databaseConfigLoader.loadDatabaseConfiguration();
                    this.configCache.set(dbConfig);
                }
                catch (RuntimeException e) {
                    this.possiblySetup.set(false);
                    throw e;
                }
            }
            this.definitelySetup.set(true);
            DatabaseConfig databaseConfig = dbConfig;
            return databaseConfig;
        }
        finally {
            this.setupLock.unlock();
        }
    }

    @Override
    public void doNowOrWhenDatabaseActivated(Runnable runnable, String desc) {
        this.doNowOrEnqueue(ACTIVATED, this.postDbSetupQueue, runnable, desc);
    }

    @Override
    public void doNowOrWhenDatabaseConfigured(Runnable runnable, String desc) {
        this.doNowOrEnqueue(CONFIGURED_PRE_ACTIVATED, this.postDbConfiguredQueue, runnable, desc);
    }

    void configureOfbiz(DatabaseConfig databaseConfig) {
        log.debug((Object)"Configuring Ofbiz");
        DatasourceInfo datasourceInfo = databaseConfig.getDatasourceInfo();
        EntityConfigUtil.getInstance().addDatasourceInfo(datasourceInfo);
        String delegatorName = databaseConfig.getDelegatorName();
        log.debug((Object)("delegator name is " + delegatorName));
        EntityConfigUtil.DelegatorInfo delegatorInfo = new EntityConfigUtil.DelegatorInfo(delegatorName, "main", "main", MapBuilder.singletonMap("default", databaseConfig.getDatasourceName()));
        EntityConfigUtil.getInstance().addDelegatorInfo(delegatorInfo);
        this.ofBizConfigured = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDatabaseSetup() {
        try {
            this.setupLock.lock();
            if (!this.possiblySetup.get()) {
                boolean bl = false;
                return bl;
            }
            this.getDatabaseConfiguration();
            boolean bl = this.definitelySetup.get();
            return bl;
        }
        catch (RuntimeException e) {
            log.debug((Object)"database is not setup");
            boolean bl = false;
            return bl;
        }
        finally {
            this.setupLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activateDatabase() {
        log.debug((Object)"activating database");
        try {
            this.setupLock.lock();
            DatabaseConfig databaseConfiguration = this.getDatabaseConfiguration();
            SystemTenant systemTenant = (SystemTenant)MultiTenantContext.getSystemTenant();
            PropertiesManager propertiesManager = this.componentLocator.getComponentInstanceOfType(PropertiesManager.class);
            systemTenant.putConfig(DatabaseConfig.class, databaseConfiguration);
            this.configureOfbiz(databaseConfiguration);
            for (Runnable runnable : this.postDbConfiguredQueue) {
                runnable.run();
            }
            propertiesManager.onDatabaseConfigured();
            this.definitelySetup.set(true);
            for (Runnable runnable : this.postDbSetupQueue) {
                runnable.run();
            }
        }
        finally {
            this.setupLock.unlock();
        }
    }

    @Override
    public DatabaseConfig getInternalDatabaseConfiguration() {
        return (DatabaseConfig)this.internalConfig.get();
    }

    void doNowOrEnqueue(String queueDesc, LinkedBlockingQueue<Runnable> queue, Runnable runnable, String desc) {
        Assertions.notNull("runnable", runnable);
        Assertions.notBlank("desc", desc);
        if (this.isDatabaseSetup()) {
            if (!this.ofBizConfigured) {
                this.configureOfbiz(this.getDatabaseConfiguration());
            }
            log.info((Object)("Now running " + desc + ""));
            runnable.run();
        } else {
            log.info((Object)"The database is not yet configured");
            log.info((Object)("Enqueuing " + desc + "' on " + queueDesc + " queue"));
            queue.add(runnable);
        }
    }
}

